/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ContentTypes;
import com.github.tomakehurst.wiremock.common.Gzip;
import com.github.tomakehurst.wiremock.common.IdGenerator;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.UniqueFilenameGenerator;
import com.github.tomakehurst.wiremock.common.VeryShortIdGenerator;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.http.CaseInsensitiveKey;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestListener;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.MultipartValuePattern;
import com.github.tomakehurst.wiremock.matching.MultipartValuePatternBuilder;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.store.BlobStore;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.verification.VerificationResult;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

@Deprecated
public class StubMappingJsonRecorder
implements RequestListener {
    private final BlobStore mappingsBlobStore;
    private final BlobStore filesBlobStore;
    private final Admin admin;
    private final List<CaseInsensitiveKey> headersToMatch;
    private IdGenerator idGenerator;

    public StubMappingJsonRecorder(BlobStore mappingsBlobStore, BlobStore filesBlobStore, Admin admin, List<CaseInsensitiveKey> headersToMatch) {
        this.mappingsBlobStore = mappingsBlobStore;
        this.filesBlobStore = filesBlobStore;
        this.admin = admin;
        this.headersToMatch = headersToMatch;
        this.idGenerator = new VeryShortIdGenerator();
    }

    @Override
    public void requestReceived(Request request2, Response response) {
        RequestPattern requestPattern = this.buildRequestPatternFrom(request2);
        if (this.requestNotAlreadyReceived(requestPattern) && response.isFromProxy()) {
            LocalNotifier.notifier().info(String.format("Recording mappings for %s", request2.getUrl()));
            this.writeToMappingAndBodyFile(request2, response, requestPattern);
        } else {
            LocalNotifier.notifier().info(String.format("Not recording mapping for %s as this has already been received", request2.getUrl()));
        }
    }

    private RequestPattern buildRequestPatternFrom(Request request2) {
        RequestPatternBuilder builder = RequestPatternBuilder.newRequestPattern(request2.getMethod(), WireMock.urlEqualTo(request2.getUrl()));
        if (!this.headersToMatch.isEmpty()) {
            for (HttpHeader header : request2.getHeaders().all()) {
                if (!this.headersToMatch.contains(header.caseInsensitiveKey())) continue;
                builder.withHeader(header.key(), WireMock.equalTo(header.firstValue()));
            }
        }
        if (request2.isMultipart() && request2.getParts() != null) {
            for (Request.Part part : request2.getParts()) {
                builder.withRequestBodyPart(this.valuePatternForPart(part));
            }
        } else {
            String body2 = request2.getBodyAsString();
            if (!body2.isEmpty()) {
                builder.withRequestBody(this.valuePatternForContentType(request2));
            }
        }
        return builder.build();
    }

    private MultipartValuePattern valuePatternForPart(Request.Part part) {
        HttpHeader contentType;
        MultipartValuePatternBuilder builder = new MultipartValuePatternBuilder().withName(part.getName()).matchingType(MultipartValuePattern.MatchingType.ALL);
        if (!this.headersToMatch.isEmpty()) {
            Collection<HttpHeader> all = part.getHeaders().all();
            for (HttpHeader httpHeader : all) {
                if (!this.headersToMatch.contains(httpHeader.caseInsensitiveKey())) continue;
                builder.withHeader(httpHeader.key(), WireMock.equalTo(httpHeader.firstValue()));
            }
        }
        if (!(contentType = part.getHeader("Content-Type")).isPresent() || contentType.firstValue().contains("text")) {
            builder.withBody(WireMock.equalTo(part.getBody().asString()));
        } else if (contentType.firstValue().contains("json")) {
            builder.withBody(WireMock.equalToJson(part.getBody().asString(), true, true));
        } else if (contentType.firstValue().contains("xml")) {
            builder.withBody(WireMock.equalToXml(part.getBody().asString()));
        } else {
            builder.withBody(WireMock.binaryEqualTo(part.getBody().asBytes()));
        }
        return builder.build();
    }

    private StringValuePattern valuePatternForContentType(Request request2) {
        String contentType = request2.getHeader("Content-Type");
        if (contentType != null) {
            if (contentType.contains("json")) {
                return WireMock.equalToJson(request2.getBodyAsString(), true, true);
            }
            if (contentType.contains("xml")) {
                return WireMock.equalToXml(request2.getBodyAsString());
            }
        }
        return WireMock.equalTo(request2.getBodyAsString());
    }

    private void writeToMappingAndBodyFile(Request request2, Response response, RequestPattern requestPattern) {
        String fileId = this.idGenerator.generate();
        byte[] body2 = this.bodyDecompressedIfRequired(response);
        String mappingFileName = UniqueFilenameGenerator.generate(request2.getUrl(), "mapping", fileId);
        String bodyFileName = UniqueFilenameGenerator.generate(request2.getUrl(), "body", fileId, ContentTypes.determineFileExtension(request2.getUrl(), response.getHeaders().getContentTypeHeader(), body2));
        ResponseDefinitionBuilder responseDefinitionBuilder = ResponseDefinitionBuilder.responseDefinition().withStatus(response.getStatus()).withBodyFile(bodyFileName);
        if (response.getHeaders().size() > 0) {
            responseDefinitionBuilder.withHeaders(this.withoutContentEncodingAndContentLength(response.getHeaders()));
        }
        ResponseDefinition responseToWrite = responseDefinitionBuilder.build();
        StubMapping mapping = new StubMapping(requestPattern, responseToWrite);
        mapping.setUuid(UUID.nameUUIDFromBytes(fileId.getBytes()));
        this.filesBlobStore.put(bodyFileName, body2);
        this.mappingsBlobStore.put(mappingFileName, Strings.bytesFromString(Json.write(mapping)));
    }

    private HttpHeaders withoutContentEncodingAndContentLength(HttpHeaders httpHeaders) {
        return new HttpHeaders(httpHeaders.all().stream().filter(header -> !header.keyEquals("Content-Encoding") && !header.keyEquals("Content-Length")).collect(Collectors.toList()));
    }

    private byte[] bodyDecompressedIfRequired(Response response) {
        if (response.getHeaders().getHeader("Content-Encoding").containsValue("gzip")) {
            return Gzip.unGzip(response.getBody());
        }
        return response.getBody();
    }

    private boolean requestNotAlreadyReceived(RequestPattern requestPattern) {
        VerificationResult verificationResult = this.admin.countRequestsMatching(requestPattern);
        verificationResult.assertRequestJournalEnabled();
        return verificationResult.getCount() < 1;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }
}

