/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.common.DataTruncationSettings;
import com.github.tomakehurst.wiremock.common.Timing;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.PostServeActionDefinition;
import com.github.tomakehurst.wiremock.extension.ServeEventListenerDefinition;
import com.github.tomakehurst.wiremock.http.LoggedResponse;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestIdDecorator;
import com.github.tomakehurst.wiremock.http.RequestPathParamsDecorator;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import wiremock.com.fasterxml.jackson.annotation.JsonCreator;
import wiremock.com.fasterxml.jackson.annotation.JsonIgnore;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;
import wiremock.com.google.common.base.Stopwatch;

public class ServeEvent {
    public static final String ORIGINAL_SERVE_EVENT_KEY = "wiremock.ORIGINAL_SERVE_EVENT";
    private final UUID id;
    private final LoggedRequest request;
    private final StubMapping stubMapping;
    private final ResponseDefinition responseDefinition;
    private final LoggedResponse response;
    private final Timing timing;
    private final ConcurrentLinkedQueue<SubEvent> subEvents;
    private final Stopwatch stopwatch;

    protected ServeEvent(UUID id, LoggedRequest request2, StubMapping stubMapping, ResponseDefinition responseDefinition, LoggedResponse response, Timing timing, ConcurrentLinkedQueue<SubEvent> subEvents, Stopwatch stopwatch) {
        this.id = id;
        this.request = request2;
        this.stubMapping = stubMapping;
        this.responseDefinition = responseDefinition;
        this.response = response;
        this.timing = timing;
        this.subEvents = subEvents;
        this.stopwatch = stopwatch;
    }

    @JsonCreator
    public ServeEvent(@JsonProperty(value="id") UUID id, @JsonProperty(value="request") LoggedRequest request2, @JsonProperty(value="mapping") StubMapping stubMapping, @JsonProperty(value="responseDefinition") ResponseDefinition responseDefinition, @JsonProperty(value="response") LoggedResponse response, @JsonProperty(value="wasMatched") boolean ignoredReadOnly, @JsonProperty(value="timing") Timing timing, @JsonProperty(value="subEvents") Queue<SubEvent> subEvents) {
        this(id, request2, stubMapping, responseDefinition, response, timing != null ? timing : Timing.create(), subEvents != null ? new ConcurrentLinkedQueue<SubEvent>(subEvents) : new ConcurrentLinkedQueue(), Stopwatch.createStarted());
    }

    protected ServeEvent(LoggedRequest request2, StubMapping stubMapping, ResponseDefinition responseDefinition) {
        this(UUID.randomUUID(), request2, stubMapping, responseDefinition, null, false, null, null);
    }

    public static ServeEvent of(Request request2) {
        return new ServeEvent(LoggedRequest.createFrom(request2), null, null);
    }

    public static ServeEvent ofUnmatched(LoggedRequest request2, ResponseDefinition responseDefinition) {
        return new ServeEvent(request2, null, responseDefinition);
    }

    public ServeEvent replaceRequest(Request request2) {
        return new ServeEvent(this.id, LoggedRequest.createFrom(request2), this.stubMapping, this.responseDefinition, this.response, this.timing, this.subEvents, this.stopwatch);
    }

    public ServeEvent withStubMapping(StubMapping stubMapping) {
        return new ServeEvent(this.id, this.request, stubMapping, this.responseDefinition, this.response, false, this.timing, this.subEvents);
    }

    public ServeEvent withResponseDefinition(ResponseDefinition responseDefinition) {
        return new ServeEvent(this.id, this.request, this.stubMapping, responseDefinition, this.response, false, this.timing, this.subEvents);
    }

    public ServeEvent withPathParamDecoratedRequest() {
        LoggedRequest newLoggedRequest = LoggedRequest.createFrom(RequestPathParamsDecorator.decorate(this.request, this.stubMapping.getRequest()));
        return new ServeEvent(this.id, newLoggedRequest, this.stubMapping, this.responseDefinition, this.response, false, this.timing, this.subEvents);
    }

    public ServeEvent withIdDecoratedRequest() {
        LoggedRequest newLoggedRequest = LoggedRequest.createFrom(new RequestIdDecorator(this.request, this.id));
        return new ServeEvent(this.id, newLoggedRequest, this.stubMapping, this.responseDefinition, this.response, false, this.timing, this.subEvents);
    }

    public ServeEvent complete(Response response, DataTruncationSettings dataTruncationSettings) {
        this.timing.logProcessTime(this.stopwatch);
        this.timing.setAddedTime((int)response.getInitialDelay());
        return new ServeEvent(this.id, this.request, this.stubMapping, this.responseDefinition, LoggedResponse.from(response, dataTruncationSettings.getMaxResponseBodySize()), false, this.timing, this.subEvents);
    }

    public void beforeSend() {
        this.stopwatch.reset();
    }

    public void afterSend() {
        this.timing.logResponseSendTime(this.stopwatch);
    }

    @JsonIgnore
    public boolean isNoExactMatch() {
        return this.responseDefinition == null || !this.responseDefinition.wasConfigured();
    }

    public UUID getId() {
        return this.id;
    }

    public LoggedRequest getRequest() {
        return this.request;
    }

    public ResponseDefinition getResponseDefinition() {
        return this.responseDefinition;
    }

    public boolean getWasMatched() {
        return this.responseDefinition.wasConfigured();
    }

    public StubMapping getStubMapping() {
        return this.stubMapping;
    }

    public LoggedResponse getResponse() {
        return this.response;
    }

    public Timing getTiming() {
        return this.timing;
    }

    public Queue<? extends SubEvent> getSubEvents() {
        return this.subEvents;
    }

    public void appendSubEvent(String type, Object data) {
        long elapsedNanos = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
        this.appendSubEvent(new SubEvent(type, (Long)elapsedNanos, data));
    }

    public void appendSubEvent(SubEvent subEvent) {
        if (this.hasNotAlreadyBeenAppended(subEvent)) {
            this.subEvents.add(subEvent);
        }
    }

    private boolean hasNotAlreadyBeenAppended(SubEvent subEvent) {
        if (!subEvent.isStandardType()) {
            return true;
        }
        return this.subEvents.stream().noneMatch(subEvent::isEquivalentStandardTypedEventTo);
    }

    @JsonIgnore
    public Optional<SubEvent> getDiffSubEvent() {
        return this.subEvents.stream().filter(subEvent -> subEvent.getType().equals("REQUEST_NOT_MATCHED")).findFirst();
    }

    @JsonIgnore
    public List<PostServeActionDefinition> getPostServeActions() {
        return this.stubMapping != null && this.stubMapping.getPostServeActions() != null ? this.getStubMapping().getPostServeActions() : Collections.emptyList();
    }

    @JsonIgnore
    public List<ServeEventListenerDefinition> getServeEventListeners() {
        return this.stubMapping != null && this.stubMapping.getServeEventListeners() != null ? this.getStubMapping().getServeEventListeners() : Collections.emptyList();
    }

    @JsonIgnore
    public Parameters getTransformerParameters() {
        return this.stubMapping != null && this.stubMapping.getResponse() != null && this.stubMapping.getResponse().getTransformerParameters() != null ? this.stubMapping.getResponse().getTransformerParameters() : Parameters.empty();
    }
}

