/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.security;

import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.security.Authenticator;
import java.util.List;

public class SingleHeaderAuthenticator
implements Authenticator {
    private final String key;
    private final String value;

    public SingleHeaderAuthenticator(String key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public boolean authenticate(Request request2) {
        HttpHeader requestHeader = request2.header(this.key);
        if (requestHeader == null || !requestHeader.isPresent()) {
            return false;
        }
        List<String> headerValues = requestHeader.values();
        return request2.containsHeader("Authorization") && headerValues.contains(this.value);
    }
}

