/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.junit;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import org.junit.rules.MethodRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class WireMockClassRule
extends WireMockServer
implements MethodRule,
TestRule {
    public WireMockClassRule(Options options2) {
        super(options2);
    }

    public WireMockClassRule(int port, Integer httpsPort) {
        this(WireMockConfiguration.wireMockConfig().port(port).httpsPort(httpsPort));
    }

    public WireMockClassRule(int port) {
        this(WireMockConfiguration.wireMockConfig().port(port));
    }

    public WireMockClassRule() {
        this(WireMockConfiguration.wireMockConfig());
    }

    public Statement apply(Statement base, FrameworkMethod method, Object target) {
        return this.apply(base, null);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                if (WireMockClassRule.this.isRunning()) {
                    try {
                        WireMockClassRule.this.before();
                        base.evaluate();
                    }
                    finally {
                        WireMockClassRule.this.after();
                        WireMockClassRule.this.client.resetMappings();
                    }
                }
                WireMockClassRule.this.start();
                if (WireMockClassRule.this.options.getHttpDisabled()) {
                    WireMock.configureFor("https", "localhost", WireMockClassRule.this.httpsPort());
                } else {
                    WireMock.configureFor("http", "localhost", WireMockClassRule.this.port());
                }
                try {
                    WireMockClassRule.this.before();
                    base.evaluate();
                }
                finally {
                    WireMockClassRule.this.after();
                    WireMockClassRule.this.stop();
                }
            }
        };
    }

    protected void before() {
    }

    protected void after() {
    }
}

