/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.admin.AdminRoutes;
import com.github.tomakehurst.wiremock.admin.AdminTask;
import com.github.tomakehurst.wiremock.admin.NotFoundException;
import com.github.tomakehurst.wiremock.common.DataTruncationSettings;
import com.github.tomakehurst.wiremock.common.InvalidInputException;
import com.github.tomakehurst.wiremock.common.InvalidParameterException;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.NotPermittedException;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.common.url.PathParams;
import com.github.tomakehurst.wiremock.common.url.PathTemplate;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestFilter;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestFilterV2;
import com.github.tomakehurst.wiremock.http.AbstractRequestHandler;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.ResponseRenderer;
import com.github.tomakehurst.wiremock.security.Authenticator;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.net.URI;
import java.util.List;

public class AdminRequestHandler
extends AbstractRequestHandler {
    private final AdminRoutes adminRoutes;
    private final Admin admin;
    private final Authenticator authenticator;
    private final boolean requireHttps;

    public AdminRequestHandler(AdminRoutes adminRoutes, Admin admin, ResponseRenderer responseRenderer, Authenticator authenticator, boolean requireHttps, List<RequestFilter> requestFilters, List<RequestFilterV2> v2RequestFilters, DataTruncationSettings dataTruncationSettings) {
        super(responseRenderer, requestFilters, v2RequestFilters, dataTruncationSettings);
        this.adminRoutes = adminRoutes;
        this.admin = admin;
        this.authenticator = authenticator;
        this.requireHttps = requireHttps;
    }

    @Override
    public ServeEvent handleRequest(ServeEvent initialServeEvent) {
        LoggedRequest request2 = initialServeEvent.getRequest();
        boolean isRequestHttps = URI.create(request2.getAbsoluteUrl()).getScheme().equals("https");
        if (this.requireHttps && !isRequestHttps) {
            LocalNotifier.notifier().info("HTTPS is required for admin requests, sending upgrade redirect");
            return initialServeEvent.withResponseDefinition(ResponseDefinition.notPermitted("HTTPS is required for accessing the admin API"));
        }
        if (!this.authenticator.authenticate(request2)) {
            LocalNotifier.notifier().info("Authentication failed for " + request2.getMethod() + " " + request2.getUrl());
            return initialServeEvent.withResponseDefinition(ResponseDefinition.notAuthorised());
        }
        LocalNotifier.notifier().info("Admin request received:\n" + this.formatRequest(request2));
        String path = Urls.getPath(AdminRequestHandler.withoutAdminRoot(request2.getUrl()));
        try {
            AdminTask adminTask = this.adminRoutes.taskFor(request2.getMethod(), path);
            PathTemplate uriTemplate = this.adminRoutes.requestSpecForTask(adminTask.getClass()).getUriTemplate();
            PathParams pathParams = uriTemplate.parse(path);
            return initialServeEvent.withResponseDefinition(adminTask.execute(this.admin, initialServeEvent, pathParams));
        }
        catch (NotFoundException e) {
            return initialServeEvent.withResponseDefinition(ResponseDefinition.notConfigured());
        }
        catch (InvalidParameterException ipe) {
            return initialServeEvent.withResponseDefinition(ResponseDefinition.badRequest(ipe.getErrors()));
        }
        catch (InvalidInputException iie) {
            return initialServeEvent.withResponseDefinition(ResponseDefinition.badRequestEntity(iie.getErrors()));
        }
        catch (NotPermittedException npe) {
            return initialServeEvent.withResponseDefinition(ResponseDefinition.notPermitted(npe.getErrors()));
        }
        catch (Throwable t2) {
            LocalNotifier.notifier().error("Unrecoverable error handling admin request", t2);
            throw t2;
        }
    }

    private static String withoutAdminRoot(String url) {
        return url.replace("/__admin", "");
    }
}

