/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import wiremock.com.github.jknack.handlebars.Options;

public class MathsHelper
extends HandlebarsHelper<Object> {
    @Override
    public Object apply(Object context, Options options2) throws IOException {
        if (options2.params.length != 2) {
            return this.handleError("All maths functions require two operands and an operator as parameters e.g. 3 '+' 2");
        }
        BigDecimal left = MathsHelper.coerceToBigDecimal(context);
        String operator = options2.params[0].toString();
        BigDecimal right = MathsHelper.coerceToBigDecimal(options2.params[1]);
        BigDecimal result = null;
        switch (operator) {
            case "+": {
                result = left.add(right);
                break;
            }
            case "-": {
                result = left.subtract(right);
                break;
            }
            case "*": 
            case "x": {
                result = left.multiply(right);
                break;
            }
            case "/": {
                result = left.divide(right, RoundingMode.HALF_UP);
                break;
            }
            case "%": {
                result = left.remainder(right);
                break;
            }
            default: {
                return this.handleError(operator + " is not a valid mathematical operator");
            }
        }
        return MathsHelper.reduceToPrimitiveNumber(result);
    }

    private static BigDecimal coerceToBigDecimal(Object value) {
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        }
        if (value instanceof Long) {
            return new BigDecimal((Long)value);
        }
        if (value instanceof Double) {
            return BigDecimal.valueOf((Double)value);
        }
        if (value instanceof Float) {
            return BigDecimal.valueOf(((Float)value).floatValue());
        }
        try {
            return new BigDecimal(value.toString());
        }
        catch (NumberFormatException e) {
            return new BigDecimal(0);
        }
    }

    private static Object reduceToPrimitiveNumber(BigDecimal value) {
        if (value == null) {
            return null;
        }
        if (value.scale() == 0) {
            long longValue = value.longValue();
            if (longValue <= Integer.MAX_VALUE && longValue >= Integer.MIN_VALUE) {
                return value.intValue();
            }
            return longValue;
        }
        return value.doubleValue();
    }
}

