/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.AbstractArrayHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import wiremock.com.github.jknack.handlebars.Options;

public class ArrayRemoveHelper
extends AbstractArrayHelper {
    @Override
    public Object apply(List<?> list, Options options2) throws IOException {
        Integer position;
        try {
            position = this.parsePosition(options2);
        }
        catch (NumberFormatException e) {
            return this.handleError("position must be 'start', 'end' or an integer");
        }
        Integer positionToRemove = ParameterUtils.getFirstNonNull(position, list.size() - 1);
        ArrayList mutableList = new ArrayList(list);
        if (position != null && (position < 0 || position > mutableList.size())) {
            return this.handleError("position must be greater than or equal to 0 and less than or equal to the size of the list");
        }
        mutableList.remove(positionToRemove);
        return mutableList;
    }
}

