/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import java.lang.reflect.Array;
import java.util.Arrays;

public final class ArrayFunctions {
    public static <T> T[] concat(T[] first, T[] second) {
        if (first.length + second.length == 0) {
            return first;
        }
        T[] both = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, both, first.length, second.length);
        return both;
    }

    public static <T> T[] prepend(T t2, T[] original) {
        Object[] newArray = (Object[])Array.newInstance(original.getClass().getComponentType(), original.length + 1);
        newArray[0] = t2;
        System.arraycopy(original, 0, newArray, 1, original.length);
        return newArray;
    }

    private ArrayFunctions() {
        throw new UnsupportedOperationException("not instantiable");
    }
}

