/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.weld.ServiceNames;
import org.jboss.as.weld.WeldBootstrapService;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WeldStartCompletionService
implements Service {
    public static final ServiceName SERVICE_NAME = ServiceNames.WELD_START_COMPLETION_SERVICE_NAME;
    private final Supplier<WeldBootstrapService> bootstrapSupplier;
    private final List<SetupAction> setupActions;
    private final ClassLoader classLoader;
    private final AtomicBoolean runOnce = new AtomicBoolean();

    public WeldStartCompletionService(Supplier<WeldBootstrapService> bootstrapSupplier, List<SetupAction> setupActions, ClassLoader classLoader) {
        this.bootstrapSupplier = bootstrapSupplier;
        this.setupActions = setupActions;
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) {
        if (!this.runOnce.compareAndSet(false, true)) {
            return;
        }
        ClassLoader oldTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            for (SetupAction action : this.setupActions) {
                action.setup(null);
            }
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            this.bootstrapSupplier.get().getBootstrap().endInitialization();
        }
        finally {
            for (SetupAction action : this.setupActions) {
                try {
                    action.teardown(null);
                }
                catch (Exception e) {
                    WeldLogger.DEPLOYMENT_LOGGER.exceptionClearingThreadState(e);
                }
            }
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
        }
    }

    public void stop(StopContext context) {
    }
}

