/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.servlet.ServletContext;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.ThreadBindingListener;
import org.apache.catalina.core.StandardContext;
import org.apache.tomcat.InstanceManager;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.web.ThreadSetupBindingListener;
import org.jboss.as.web.WebLogger;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.common.ServletContextAttribute;
import org.jboss.as.web.common.StartupContext;
import org.jboss.as.web.common.WebInjectionContainer;
import org.jboss.as.web.deployment.WebInstanceManager;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class WebDeploymentService
implements Service<StandardContext> {
    private final StandardContext context;
    private final InjectedValue<Realm> realm = new InjectedValue();
    private final WebInjectionContainer injectionContainer;
    private final List<SetupAction> setupActions;
    final List<ServletContextAttribute> attributes;
    private final InjectedValue<ExecutorService> serverExecutor = new InjectedValue();

    public WebDeploymentService(StandardContext context, WebInjectionContainer injectionContainer, List<SetupAction> setupActions, List<ServletContextAttribute> attributes) {
        this.context = context;
        this.injectionContainer = injectionContainer;
        this.setupActions = setupActions;
        this.attributes = attributes;
    }

    InjectedValue<Realm> getRealm() {
        return this.realm;
    }

    public synchronized void start(final StartContext startContext) throws StartException {
        startContext.asynchronous();
        ((ExecutorService)this.serverExecutor.getValue()).submit(new Runnable(){

            @Override
            public void run() {
                try {
                    WebDeploymentService.this.doStart();
                    startContext.complete();
                }
                catch (Throwable e) {
                    startContext.failed(new StartException(e));
                }
            }
        });
    }

    public synchronized void stop(final StopContext stopContext) {
        stopContext.asynchronous();
        ((ExecutorService)this.serverExecutor.getValue()).submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    WebDeploymentService.this.doStop();
                }
                finally {
                    stopContext.complete();
                }
            }
        });
    }

    public synchronized StandardContext getValue() throws IllegalStateException {
        if (this.context == null) {
            throw new IllegalStateException();
        }
        return this.context;
    }

    Injector<ExecutorService> getServerExecutorInjector() {
        return this.serverExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStart() throws StartException {
        StartupContext.setInjectionContainer((WebInjectionContainer)this.injectionContainer);
        try {
            if (this.attributes != null) {
                ServletContext context = this.context.getServletContext();
                for (ServletContextAttribute attribute : this.attributes) {
                    context.setAttribute(attribute.getName(), attribute.getValue());
                }
            }
            this.context.setRealm((Realm)this.realm.getValue());
            ArrayList<SetupAction> actions = new ArrayList<SetupAction>();
            actions.addAll(this.setupActions);
            this.context.setInstanceManager((InstanceManager)new WebInstanceManager(this.injectionContainer));
            this.context.setThreadBindingListener((ThreadBindingListener)new ThreadSetupBindingListener(actions));
            WebLogger.WEB_LOGGER.registerWebapp(this.context.getName());
            try {
                this.context.create();
            }
            catch (Exception e) {
                throw new StartException(WebMessages.MESSAGES.createContextFailed(), (Throwable)e);
            }
            try {
                this.context.start();
            }
            catch (LifecycleException e) {
                throw new StartException(WebMessages.MESSAGES.startContextFailed(), (Throwable)e);
            }
            if (this.context.getState() != 1) {
                throw new StartException(WebMessages.MESSAGES.startContextFailed());
            }
        }
        finally {
            StartupContext.setInjectionContainer(null);
        }
    }

    private void doStop() {
        WebLogger.WEB_LOGGER.unregisterWebapp(this.context.getName());
        try {
            this.context.stop();
        }
        catch (LifecycleException e) {
            WebLogger.WEB_LOGGER.stopContextFailed(e);
        }
        try {
            this.context.destroy();
        }
        catch (Exception e) {
            WebLogger.WEB_LOGGER.destroyContextFailed(e);
        }
    }
}

