/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.web.WebMessages;
import org.jboss.dmr.ModelNode;

public class WebValveParamAdd
implements OperationStepHandler {
    static final WebValveParamAdd INSTANCE = new WebValveParamAdd();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode mimetypes = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel().get("param");
        if (!operation.hasDefined("param-name") || !operation.hasDefined("param-value")) {
            throw new OperationFailedException(WebMessages.MESSAGES.paramNameAndParamValueRequiredForAddParam());
        }
        mimetypes.get(operation.get("param-name").asString()).set(operation.get("param-value").asString());
        if (!context.isBooting() && context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.reloadRequired();
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            context.revertReloadRequired();
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }
}

