/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.SessionManagerFactory;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.session.SessionAffinityProvider;
import org.wildfly.service.descriptor.ServiceDescriptor;

public interface WebDeploymentServiceDescriptor<T>
extends ServiceDescriptor<T> {
    public static final WebDeploymentServiceDescriptor<Deployment> DEPLOYMENT = WebDeploymentServiceDescriptor.of("deployment", Deployment.class);
    public static final WebDeploymentServiceDescriptor<DeploymentInfo> DEPLOYMENT_INFO = WebDeploymentServiceDescriptor.of("deployment-info", DeploymentInfo.class);
    public static final WebDeploymentServiceDescriptor<SessionManagerFactory> SESSION_MANAGER_FACTORY = WebDeploymentServiceDescriptor.of("session-manager-factory", SessionManagerFactory.class);
    public static final WebDeploymentServiceDescriptor<SessionAffinityProvider> SESSION_AFFINITY_PROVIDER = WebDeploymentServiceDescriptor.of("session-affinity-provider", SessionAffinityProvider.class);

    default public ServiceName resolve(DeploymentUnit unit) {
        return unit.getServiceName().append(new String[]{"undertow", this.getName()});
    }

    default public <U extends T> WebDeploymentServiceDescriptor<U> asType(final Class<U> type) {
        return new WebDeploymentServiceDescriptor<U>(){

            public String getName() {
                return WebDeploymentServiceDescriptor.this.getName();
            }

            public Class<U> getType() {
                return type;
            }

            @Override
            public ServiceName resolve(DeploymentUnit unit) {
                return WebDeploymentServiceDescriptor.this.resolve(unit);
            }
        };
    }

    public static <T> WebDeploymentServiceDescriptor<T> of(final String name, final Class<T> type) {
        return new WebDeploymentServiceDescriptor<T>(){

            public String getName() {
                return name;
            }

            public Class<T> getType() {
                return type;
            }
        };
    }
}

