/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.session;

import org.jboss.as.web.session.RoutingSupport;
import org.jboss.as.web.session.SessionIdentifierCodec;
import org.jboss.as.web.session.SimpleRoutingSupport;
import org.wildfly.extension.undertow.session.SessionAffinityProvider;

public class AffinitySessionIdentifierCodec
implements SessionIdentifierCodec {
    private final SessionAffinityProvider provider;
    private final RoutingSupport routing;

    public AffinitySessionIdentifierCodec(SessionAffinityProvider provider) {
        this(provider, (RoutingSupport)new SimpleRoutingSupport());
    }

    public AffinitySessionIdentifierCodec(SessionAffinityProvider provider, RoutingSupport routing) {
        this.provider = provider;
        this.routing = routing;
    }

    public CharSequence encode(CharSequence sessionId) {
        String route = this.provider.getAffinity(sessionId.toString()).orElse(null);
        return route != null ? this.routing.format(sessionId, (CharSequence)route) : sessionId;
    }

    public CharSequence decode(CharSequence encodedSessionId) {
        return (CharSequence)this.routing.parse(encodedSessionId).getKey();
    }
}

