/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.service;

import com.arjuna.ats.jta.transaction.Transaction;
import io.undertow.server.handlers.PathHandler;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.msc.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.httpclient.transaction.HttpRemoteTransactionService;
import org.wildfly.transaction.client.LocalTransactionContext;

public class TransactionRemoteHTTPService
implements Service {
    private final Consumer<TransactionRemoteHTTPService> httpServiceConsumer;
    private final Supplier<LocalTransactionContext> localTransactionContextSupplier;
    private final Supplier<PathHandler> pathHandlerSupplier;

    public TransactionRemoteHTTPService(Consumer<TransactionRemoteHTTPService> httpServiceConsumer, Supplier<LocalTransactionContext> localTransactionContextSupplier, Supplier<PathHandler> pathHandlerSupplier) {
        this.httpServiceConsumer = httpServiceConsumer;
        this.localTransactionContextSupplier = localTransactionContextSupplier;
        this.pathHandlerSupplier = pathHandlerSupplier;
    }

    public void start(StartContext context) throws StartException {
        HttpRemoteTransactionService transactionService = new HttpRemoteTransactionService(this.localTransactionContextSupplier.get(), transaction -> ((Transaction)transaction.getProviderInterface(Transaction.class)).getTxId());
        this.pathHandlerSupplier.get().addPrefixPath("/txn", transactionService.createHandler());
        this.httpServiceConsumer.accept(this);
    }

    public void stop(StopContext context) {
        this.httpServiceConsumer.accept(null);
        this.pathHandlerSupplier.get().removePrefixPath("/txn");
    }
}

