/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.service;

import jakarta.transaction.TransactionManager;
import java.security.AccessController;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.as.txn.service.UserTransactionRegistryService;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.tm.usertx.UserTransactionRegistry;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.transaction.client.AbstractTransaction;
import org.wildfly.transaction.client.AssociationListener;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.CreationListener;
import org.wildfly.transaction.client.LocalTransactionContext;

public class TransactionManagerService
implements Service {
    @Deprecated
    public static final ServiceName SERVICE_NAME = TxnServices.JBOSS_TXN_TRANSACTION_MANAGER;
    public static final ServiceName INTERNAL_SERVICE_NAME = TxnServices.JBOSS_TXN_TRANSACTION_MANAGER;
    private final Consumer<TransactionManager> txnManagerConsumer;
    private final Supplier<UserTransactionRegistry> registrySupplier;

    private TransactionManagerService(Consumer<TransactionManager> txnManagerConsumer, Supplier<UserTransactionRegistry> registrySupplier) {
        this.txnManagerConsumer = txnManagerConsumer;
        this.registrySupplier = registrySupplier;
    }

    public void start(StartContext context) throws StartException {
        final UserTransactionRegistry registry = this.registrySupplier.get();
        LocalTransactionContext.getCurrent().registerCreationListener((txn, createdBy) -> {
            if (createdBy == CreationListener.CreatedBy.USER_TRANSACTION) {
                if (WildFlySecurityManager.isChecking()) {
                    AccessController.doPrivileged(() -> {
                        txn.registerAssociationListener(new AssociationListener(){
                            private final AtomicBoolean first = new AtomicBoolean();

                            public void associationChanged(AbstractTransaction t, boolean a) {
                                if (a && this.first.compareAndSet(false, true)) {
                                    registry.userTransactionStarted();
                                }
                            }
                        });
                        return null;
                    });
                } else {
                    txn.registerAssociationListener(new AssociationListener(){
                        private final AtomicBoolean first = new AtomicBoolean();

                        public void associationChanged(AbstractTransaction t, boolean a) {
                            if (a && this.first.compareAndSet(false, true)) {
                                registry.userTransactionStarted();
                            }
                        }
                    });
                }
            }
        });
        this.txnManagerConsumer.accept((TransactionManager)ContextTransactionManager.getInstance());
    }

    public void stop(StopContext stopContext) {
        this.txnManagerConsumer.accept(null);
    }

    public static void addService(ServiceTarget target) {
        ServiceBuilder sb = target.addService();
        Consumer txnManagerConsumer = sb.provides(new ServiceName[]{INTERNAL_SERVICE_NAME});
        Supplier registrySupplier = sb.requires(UserTransactionRegistryService.SERVICE_NAME);
        sb.requires(TxnServices.JBOSS_TXN_LOCAL_TRANSACTION_CONTEXT);
        sb.setInstance((Service)new TransactionManagerService(txnManagerConsumer, registrySupplier));
        sb.install();
    }
}

