/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.logging;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.xa.Xid;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.txn.logging.TransactionLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.msc.service.StartException;

public class TransactionLogger_$logger
extends DelegatingBasicLogger
implements TransactionLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = TransactionLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public TransactionLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void unableToRollBack(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.unableToRollBack$str(), new Object[0]);
    }

    protected String unableToRollBack$str() {
        return "WFLYTX0001: Unable to roll back active transaction";
    }

    @Override
    public final void unableToGetTransactionStatus(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.unableToGetTransactionStatus$str(), new Object[0]);
    }

    protected String unableToGetTransactionStatus$str() {
        return "WFLYTX0002: Unable to get transaction state";
    }

    @Override
    public final void transactionStillOpen(int status) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, this.transactionStillOpen$str(), (Object)status);
    }

    protected String transactionStillOpen$str() {
        return "WFLYTX0003: APPLICATION ERROR: transaction still active in request with status %s";
    }

    protected String createFailed$str() {
        return "WFLYTX0004: Create failed";
    }

    @Override
    public final StartException createFailed(Throwable cause) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.createFailed$str(), new Object[0]), cause);
        TransactionLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String managerStartFailure$str() {
        return "WFLYTX0005: %s manager create failed";
    }

    @Override
    public final StartException managerStartFailure(Throwable cause, String managerName) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.managerStartFailure$str(), managerName), cause);
        TransactionLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String objectStoreStartFailure$str() {
        return "WFLYTX0006: Failed to configure object store browser bean";
    }

    @Override
    public final StartException objectStoreStartFailure(Throwable cause) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.objectStoreStartFailure$str(), new Object[0]), cause);
        TransactionLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String serviceNotStarted$str() {
        return "WFLYTX0007: Service not started";
    }

    @Override
    public final IllegalStateException serviceNotStarted() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.serviceNotStarted$str(), new Object[0]));
        TransactionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String startFailure$str() {
        return "WFLYTX0008: Start failed";
    }

    @Override
    public final StartException startFailure(Throwable cause) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.startFailure$str(), new Object[0]), cause);
        TransactionLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownMetric$str() {
        return "WFLYTX0009: Unknown metric %s";
    }

    @Override
    public final String unknownMetric(Object metric) {
        return String.format(this.getLoggingLocale(), this.unknownMetric$str(), metric);
    }

    protected String jmxSubsystemNotInstalled$str() {
        return "WFLYTX0010: MBean Server service not installed, this functionality is not available if the JMX subsystem has not been installed.";
    }

    @Override
    public final RuntimeException jmxSubsystemNotInstalled() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.jmxSubsystemNotInstalled$str(), new Object[0]));
        TransactionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String inconsistentStatisticsSettings$str() {
        return "WFLYTX0012: Attributes %s and %s are alternatives; both cannot be set with conflicting values.";
    }

    @Override
    public final OperationFailedException inconsistentStatisticsSettings(String attrOne, String attrTwo) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.inconsistentStatisticsSettings$str(), attrOne, attrTwo));
        TransactionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void nodeIdentifierIsSetToDefault(String attributeName, String subsystemAddress) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.nodeIdentifierIsSetToDefault$str(), (Object)attributeName, (Object)subsystemAddress);
    }

    protected String nodeIdentifierIsSetToDefault$str() {
        return "WFLYTX0013: The %s attribute on the %s is set to the default value. This is a danger for environments running multiple servers. Please make sure the attribute value is unique.";
    }

    protected String jndiNameInvalidFormat$str() {
        return "WFLYTX0015: Jndi names have to start with java:/ or java:jboss/";
    }

    @Override
    public final OperationFailedException jndiNameInvalidFormat() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.jndiNameInvalidFormat$str(), new Object[0]));
        TransactionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mustBeUndefinedIfTrue$str() {
        return "WFLYTX0023: %s must be undefined if %s is 'true'.";
    }

    @Override
    public final OperationFailedException mustBeUndefinedIfTrue(String attrOne, String attrTwo) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.mustBeUndefinedIfTrue$str(), attrOne, attrTwo));
        TransactionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mustBedefinedIfDefined$str() {
        return "WFLYTX0024: %s must be defined if %s is defined.";
    }

    @Override
    public final OperationFailedException mustBedefinedIfDefined(String attrOne, String attrTwo) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.mustBedefinedIfDefined$str(), attrOne, attrTwo));
        TransactionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String eitherTrueOrDefined$str() {
        return "WFLYTX0025: Either %s must be 'true' or  %s must be defined.";
    }

    @Override
    public final OperationFailedException eitherTrueOrDefined(String attrOne, String attrTwo) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.eitherTrueOrDefined$str(), attrOne, attrTwo));
        TransactionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void transactionNotFound(Transaction tx) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.transactionNotFound$str(), (Object)tx);
    }

    protected String transactionNotFound$str() {
        return "WFLYTX0026: The transaction %s could not be removed from the cache during cleanup.";
    }

    @Override
    public final void preJcaSyncAfterCompletionFailed(Synchronization preJcaSync, Transaction tx, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.preJcaSyncAfterCompletionFailed$str(), (Object)preJcaSync, (Object)tx);
    }

    protected String preJcaSyncAfterCompletionFailed$str() {
        return "WFLYTX0027: The pre-Jakarta Connectors synchronization %s associated with tx %s failed during after completion";
    }

    @Override
    public final void jcaSyncAfterCompletionFailed(Synchronization jcaSync, Transaction tx, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.jcaSyncAfterCompletionFailed$str(), (Object)jcaSync, (Object)tx);
    }

    protected String jcaSyncAfterCompletionFailed$str() {
        return "WFLYTX0028: The Jakarta Connectors synchronization %s associated with tx %s failed during after completion";
    }

    protected String syncsnotallowed$str() {
        return "WFLYTX0029: Syncs are not allowed to be registered when the tx is in state %s";
    }

    @Override
    public final IllegalStateException syncsnotallowed(int status) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.syncsnotallowed$str(), status));
        TransactionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String indexedChildResourceRegistrationNotAvailable$str() {
        return "WFLYTX0030: Indexed child resources can only be registered if the parent resource supports ordered children. The parent of '%s' is not indexed";
    }

    @Override
    public final IllegalStateException indexedChildResourceRegistrationNotAvailable(PathElement address) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.indexedChildResourceRegistrationNotAvailable$str(), address));
        TransactionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedAttribute$str() {
        return "WFLYTX0031: The attribute '%s' is no longer supported";
    }

    @Override
    public final XMLStreamException unsupportedAttribute(String attribute, Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.unsupportedAttribute$str(), attribute), location);
        TransactionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mustBeDefinedIfTrue$str() {
        return "WFLYTX0032: %s must be defined if %s is 'true'.";
    }

    @Override
    public final OperationFailedException mustBeDefinedIfTrue(String attrOne, String attrTwo) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.mustBeDefinedIfTrue$str(), attrOne, attrTwo));
        TransactionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String onlyOneCanBeTrue$str() {
        return "WFLYTX0033: Only one of %s and %s can be 'true'.";
    }

    @Override
    public final OperationFailedException onlyOneCanBeTrue(String attrOne, String attrTwo) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.onlyOneCanBeTrue$str(), attrOne, attrTwo));
        TransactionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void objectStoreRelativeToIsSetToDefault() {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.objectStoreRelativeToIsSetToDefault$str(), new Object[0]);
    }

    protected String objectStoreRelativeToIsSetToDefault$str() {
        return "WFLYTX0034: relative_to property of the object-store is set to the default value with jboss.server.data.dir";
    }

    protected String cannotFindOrImportInflowTransaction$str() {
        return "WFLYTX0035: Cannot find or import inflow transaction for xid %s and work %s";
    }

    @Override
    public final WorkCompletedException cannotFindOrImportInflowTransaction(Xid xid, Work work, Exception e) {
        WorkCompletedException result = new WorkCompletedException(String.format(this.getLoggingLocale(), this.cannotFindOrImportInflowTransaction$str(), xid, work), (Throwable)e);
        TransactionLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String importedInflowTransactionIsInactive$str() {
        return "WFLYTX0036: Imported Jakarta Connectors inflow transaction with xid %s of work %s is inactive";
    }

    @Override
    public final WorkCompletedException importedInflowTransactionIsInactive(Xid xid, Work work, Exception e) {
        WorkCompletedException result = new WorkCompletedException(String.format(this.getLoggingLocale(), this.importedInflowTransactionIsInactive$str(), xid, work), (Throwable)e);
        TransactionLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotResumeInflowTransactionUnexpectedError$str() {
        return "WFLYTX0037: Unexpected error on resuming transaction %s for work %s";
    }

    @Override
    public final WorkCompletedException cannotResumeInflowTransactionUnexpectedError(Transaction txn, Work work, Exception e) {
        WorkCompletedException result = new WorkCompletedException(String.format(this.getLoggingLocale(), this.cannotResumeInflowTransactionUnexpectedError$str(), txn, work), (Throwable)e);
        TransactionLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotSuspendInflowTransactionUnexpectedError$str() {
        return "WFLYTX0038: Unexpected error on suspending transaction for work %s";
    }

    @Override
    public final RuntimeException cannotSuspendInflowTransactionUnexpectedError(Work txn, Exception e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cannotSuspendInflowTransactionUnexpectedError$str(), txn), e);
        TransactionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void timeoutValueIsSetToMaximum(int maximum_timeout) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.timeoutValueIsSetToMaximum$str(), (Object)maximum_timeout);
    }

    protected String timeoutValueIsSetToMaximum$str() {
        return "WFLYTX0039: A value of zero is not permitted for the maximum timeout, as such the timeout has been set to %s";
    }

    protected String noActiveTransactionToRegisterSynchronization$str() {
        return "WFLYTX0040: There is no active transaction at the current context to register synchronization '%s'";
    }

    @Override
    public final IllegalStateException noActiveTransactionToRegisterSynchronization(Synchronization sync) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noActiveTransactionToRegisterSynchronization$str(), sync));
        TransactionLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

