/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.jboss.as.test.shared.CliUtils;
import org.wildfly.test.security.common.elytron.AbstractConfigurableElement;
import org.wildfly.test.security.common.elytron.CredentialReference;
import org.wildfly.test.security.common.elytron.CredentialStore;
import org.wildfly.test.security.common.elytron.Path;

public class SimpleCredentialStore
extends AbstractConfigurableElement
implements CredentialStore {
    private final Path keyStorePath;
    private final CredentialReference credential;
    private final String keyStoreType;
    private final Boolean create;
    private final Boolean modifiable;
    private final Map<String, String> aliases;

    private SimpleCredentialStore(Builder builder) {
        super(builder);
        this.keyStorePath = Objects.requireNonNull(builder.keyStorePath, "KeyStore path has to be provided");
        this.credential = builder.credential;
        this.keyStoreType = builder.keyStoreType;
        this.create = builder.create;
        this.modifiable = builder.modifiable;
        this.aliases = Collections.unmodifiableMap(new HashMap<String, String>(builder.aliases));
    }

    @Override
    public void create(CLIWrapper cli) throws Exception {
        StringBuilder sb = new StringBuilder("/subsystem=elytron/credential-store=");
        sb.append(this.name).append(":add(").append("location=").append(CliUtils.escapePath(this.keyStorePath.getPath()));
        if (this.create != null) {
            sb.append(",").append("create=").append(this.create.toString());
        }
        if (this.modifiable != null) {
            sb.append(",").append("modifiable=").append(this.modifiable.toString());
        }
        if (this.keyStoreType != null) {
            sb.append(",").append("implementation-properties={").append("\"keyStoreType\"=>\"").append(this.keyStoreType).append("\"}");
        }
        if (this.credential != null) {
            sb.append(",").append(this.credential.asString());
        }
        if (StringUtils.isNotBlank((CharSequence)this.keyStorePath.getRelativeTo())) {
            sb.append(",").append("relative-to=\"").append(this.keyStorePath.getRelativeTo()).append("\"");
        }
        sb.append(")");
        cli.sendLine(sb.toString());
        for (Map.Entry<String, String> entry : this.aliases.entrySet()) {
            cli.sendLine(String.format("/subsystem=elytron/credential-store=%s:add-alias(alias=%s, secret-value=\"%s\")", this.name, entry.getKey(), entry.getValue()));
        }
    }

    @Override
    public void remove(CLIWrapper cli) throws Exception {
        for (String alias : this.aliases.keySet()) {
            cli.sendLine(String.format("/subsystem=elytron/credential-store=%s:remove-alias(alias=%s)", this.name, alias.toLowerCase(Locale.ROOT)));
        }
        cli.sendLine(String.format("/subsystem=elytron/credential-store=%s:remove()", this.name));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractConfigurableElement.Builder<Builder> {
        private Path keyStorePath;
        private CredentialReference credential;
        private String keyStoreType;
        private Boolean create;
        private Boolean modifiable;
        private Map<String, String> aliases = new HashMap<String, String>();

        private Builder() {
        }

        public Builder withKeyStorePath(Path keyStorePath) {
            this.keyStorePath = keyStorePath;
            return this;
        }

        public Builder withCredential(CredentialReference credential) {
            this.credential = credential;
            return this;
        }

        public Builder withKeyStoreType(String keyStoreType) {
            this.keyStoreType = keyStoreType;
            return this;
        }

        public Builder withCreate(Boolean create) {
            this.create = create;
            return this;
        }

        public Builder withModifiable(Boolean modifiable) {
            this.modifiable = modifiable;
            return this;
        }

        public Builder withAlias(String alias, String secret) {
            this.aliases.put(alias, secret);
            return this;
        }

        public Builder clearAliases() {
            this.aliases.clear();
            return this;
        }

        public SimpleCredentialStore build() {
            return new SimpleCredentialStore(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

