/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared.observability.containers;

import java.util.List;
import org.jboss.arquillian.testcontainers.api.TestcontainersRequired;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.utility.DockerImageName;

@TestcontainersRequired
public abstract class BaseContainer<SELF extends GenericContainer<SELF>>
extends GenericContainer<SELF> {
    private final String containerName;
    private static final int STARTUP_ATTEMPTS = Integer.parseInt(System.getProperty("testsuite.integration.container.startup.attempts", "5"));
    protected Boolean loggingEnabled;

    public BaseContainer(String containerName, String imageName, String imageVersion, List<Integer> exposedPorts) {
        super(DockerImageName.parse((String)(imageName + ":" + imageVersion)));
        this.containerName = containerName;
        this.setExposedPorts(exposedPorts);
        this.setStartupAttempts(STARTUP_ATTEMPTS);
        this.setNetwork(Network.SHARED);
        this.checkForLogging(containerName);
        if (this.loggingEnabled.booleanValue()) {
            this.setLogConsumers(List.of(outputFrame -> {
                byte[] bytes = outputFrame.getBytes();
                if (bytes != null) {
                    this.debugLog(new String(bytes));
                }
            }));
        }
    }

    private void checkForLogging(String containerName) {
        this.loggingEnabled = Boolean.parseBoolean(System.getenv().get("TC_LOGGING")) || Boolean.parseBoolean(System.getProperty("testsuite.integration.container.logging")) || Boolean.parseBoolean(System.getProperty("testsuite.integration.container." + containerName.toLowerCase() + ".logging"));
    }

    protected void debugLog(String message) {
        this.debugLog(this.containerName, message);
    }

    protected void debugLog(String prefix, String message) {
        if (this.loggingEnabled.booleanValue()) {
            System.err.println("[" + prefix + "] " + message);
        }
    }
}

