/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.transactions;

import com.arjuna.ats.arjuna.recovery.RecoveryDriver;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.test.integration.management.ManagementOperations;
import org.jboss.as.test.integration.management.util.MgmtOperationException;
import org.jboss.as.test.shared.TimeoutUtil;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class RecoveryExecutor {
    private static final Logger log = Logger.getLogger(RecoveryExecutor.class);
    private static final ModelNode ADDRESS_TRANSACTIONS = new ModelNode().add("subsystem", "transactions");
    private static final ModelNode ADDRESS_SOCKET_BINDING = new ModelNode().add("socket-binding-group", "standard-sockets");
    private static final ModelNode ADDRESS_TRANSACTIONS_LOG_STORE = ADDRESS_TRANSACTIONS.clone().add("log-store", "log-store");
    private static final int DEFAULT_SOCKET_READ_SCAN_TIMEOUT_MS = 60000;
    private static final int RECOVERY_SCAN_RETRY_COUNT = 5;
    private final ManagementClient managementClient;
    private final AtomicReference<RecoveryDriver> recoveryDriverReference = new AtomicReference();

    public RecoveryExecutor(ManagementClient managementClient) {
        this.managementClient = managementClient;
    }

    public boolean runTransactionRecovery() {
        return this.runTransactionRecovery(60000);
    }

    public boolean runTransactionRecovery(int socketReadTimeout) {
        try {
            return this.getRecoveryDriver().synchronousVerboseScan(TimeoutUtil.adjust((int)socketReadTimeout), 5);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error when triggering transaction recovery synchronous scan with RecoveryDriver " + this.recoveryDriverReference.get() + ", based on the management client " + this.managementClient, e);
        }
    }

    public void cliRecoverAllTransactions() {
        this.executeOperation(this.managementClient, ADDRESS_TRANSACTIONS_LOG_STORE, "probe");
        ModelNode logStoreModelNode = null;
        try {
            logStoreModelNode = this.readResource(this.managementClient, ADDRESS_TRANSACTIONS_LOG_STORE);
        }
        catch (IOException | MgmtOperationException e) {
            throw new IllegalStateException("Cannot read content of the transaction log store at " + ADDRESS_TRANSACTIONS_LOG_STORE + " with the management client" + this.managementClient, e);
        }
        for (ModelNode txns : logStoreModelNode.get("transactions").asList()) {
            String txnName = txns.asProperty().getName();
            for (ModelNode participants : txns.get(txnName).get("participants").asList()) {
                String participantName = participants.asProperty().getName();
                ModelNode participantAddress = ADDRESS_TRANSACTIONS_LOG_STORE.clone().add("transactions", txnName).add("participants", participantName);
                this.executeOperation(this.managementClient, participantAddress, "recover");
            }
        }
    }

    private RecoveryDriver getRecoveryDriver() {
        if (this.recoveryDriverReference.get() != null) {
            return this.recoveryDriverReference.get();
        }
        String host = "";
        int port = 0;
        try {
            String transactionSocketBinding = this.readAttribute(this.managementClient, ADDRESS_TRANSACTIONS, "socket-binding").asString();
            ModelNode addressSocketBinding = ADDRESS_SOCKET_BINDING.clone();
            addressSocketBinding.add("socket-binding", transactionSocketBinding);
            host = this.readAttribute(this.managementClient, addressSocketBinding, "bound-address").asString();
            port = this.readAttribute(this.managementClient, addressSocketBinding, "bound-port").asInt();
            this.recoveryDriverReference.compareAndSet(null, new RecoveryDriver(port, host));
            return this.recoveryDriverReference.get();
        }
        catch (IOException | MgmtOperationException e) {
            throw new IllegalStateException("Cannot obtain RecoveryDriver for host:port (" + host + ":" + port + ") to contact the transaction recovery listener", e);
        }
    }

    private ModelNode readAttribute(ManagementClient managementClient, ModelNode address, String name) throws IOException, MgmtOperationException {
        ModelNode operation = new ModelNode();
        operation.get("address").set(address);
        operation.get("operation").set("read-attribute");
        operation.get("include-defaults").set("true");
        operation.get("resolve-expressions").set("true");
        operation.get("name").set(name);
        return ManagementOperations.executeOperation((ModelControllerClient)managementClient.getControllerClient(), (ModelNode)operation);
    }

    private ModelNode readResource(ManagementClient managementClient, ModelNode address) throws IOException, MgmtOperationException {
        ModelNode operation = new ModelNode();
        operation.get("address").set(address);
        operation.get("operation").set("read-resource");
        operation.get("include-defaults").set("true");
        operation.get("resolve-expressions").set("true");
        operation.get("recursive").set("true");
        operation.get("include-runtime").set("true");
        return ManagementOperations.executeOperation((ModelControllerClient)managementClient.getControllerClient(), (ModelNode)operation);
    }

    private void executeOperation(ManagementClient managementClient, ModelNode address, String operationName) {
        ModelNode operation = new ModelNode();
        operation.get("address").set(address);
        operation.get("operation").set(operationName);
        try {
            ManagementOperations.executeOperation((ModelControllerClient)managementClient.getControllerClient(), (ModelNode)operation);
        }
        catch (IOException | MgmtOperationException e) {
            throw new IllegalStateException("Cannot probe transaction subsystem log store at" + ADDRESS_TRANSACTIONS_LOG_STORE + " via the management client " + managementClient, e);
        }
    }

    static {
        ADDRESS_TRANSACTIONS.protect();
        ADDRESS_TRANSACTIONS.protect();
        ADDRESS_SOCKET_BINDING.protect();
    }
}

