/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared.observability.containers;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jboss.as.test.shared.TimeoutUtil;
import org.jboss.as.test.shared.observability.containers.BaseContainer;
import org.jboss.as.test.shared.observability.containers.JaegerContainer;
import org.jboss.as.test.shared.observability.signals.PrometheusMetric;
import org.jboss.as.test.shared.observability.signals.jaeger.JaegerTrace;
import org.junit.Assert;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.MountableFile;

public class OpenTelemetryCollectorContainer
extends BaseContainer<OpenTelemetryCollectorContainer> {
    public static final String IMAGE_NAME = "otel/opentelemetry-collector";
    public static final String IMAGE_VERSION = "0.115.1";
    public static final int OTLP_GRPC_PORT = 4317;
    public static final int OTLP_HTTP_PORT = 4318;
    public static final int PROMETHEUS_PORT = 1234;
    public static final int HEALTH_CHECK_PORT = 13133;
    public static final String OTEL_COLLECTOR_CONFIG_YAML = "/etc/otel-collector-config.yaml";
    private final JaegerContainer jaegerContainer;
    private final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(TimeoutUtil.adjust((int)Integer.parseInt(System.getProperty("testsuite.integration.container.timeout", "30"))));

    public OpenTelemetryCollectorContainer() {
        super("OpenTelemetryCollector", IMAGE_NAME, IMAGE_VERSION, List.of(Integer.valueOf(4317), Integer.valueOf(4318), Integer.valueOf(13133), Integer.valueOf(1234)));
        this.withCopyToContainer((Transferable)MountableFile.forClasspathResource((String)(((Object)((Object)this)).getClass().getPackageName().replace(".", "/") + "/otel-collector-config.yaml")), OTEL_COLLECTOR_CONFIG_YAML);
        this.withCommand("--config /etc/otel-collector-config.yaml");
        this.jaegerContainer = new JaegerContainer();
    }

    public void start() {
        super.start();
        this.jaegerContainer.start();
        this.debugLog("OTLP gRPC port: " + this.getMappedPort(4317));
        this.debugLog("OTLP HTTP port: " + this.getMappedPort(4318));
        this.debugLog("Prometheus port: " + this.getMappedPort(1234));
        this.debugLog("port bindings: " + String.valueOf(this.getPortBindings()));
    }

    public synchronized void stop() {
        this.jaegerContainer.stop();
        super.stop();
    }

    public String getOtlpGrpcEndpoint() {
        return "http://localhost:" + this.getMappedPort(4317);
    }

    public String getOtlpHttpEndpoint() {
        return "http://localhost:" + this.getMappedPort(4318);
    }

    public String getPrometheusUrl() {
        return "http://localhost:" + this.getMappedPort(1234) + "/metrics";
    }

    public List<JaegerTrace> getTraces(String serviceName) throws InterruptedException {
        return this.jaegerContainer.getTraces(serviceName);
    }

    public List<JaegerTrace> assertTraces(String serviceName, Consumer<List<JaegerTrace>> assertionConsumer) throws InterruptedException {
        return this.assertTraces(serviceName, assertionConsumer, this.DEFAULT_TIMEOUT);
    }

    public List<JaegerTrace> assertTraces(String serviceName, Consumer<List<JaegerTrace>> assertionConsumer, Duration timeout) throws InterruptedException {
        this.debugLog("assertTraces(...) validation starting.");
        Instant endTime = Instant.now().plus(timeout);
        AssertionError lastAssertionError = null;
        while (Instant.now().isBefore(endTime)) {
            try {
                List<JaegerTrace> traces = this.jaegerContainer.getTraces(serviceName);
                assertionConsumer.accept(traces);
                this.debugLog("assertTraces(...) validation passed.");
                return traces;
            }
            catch (AssertionError assertionError) {
                this.debugLog("assertTraces(...) validation failed - retrying.");
                lastAssertionError = assertionError;
                Thread.sleep(1000L);
            }
        }
        throw Objects.requireNonNullElseGet(lastAssertionError, AssertionError::new);
    }

    public List<PrometheusMetric> assertMetrics(Consumer<List<PrometheusMetric>> assertionConsumer) throws AssertionError, InterruptedException {
        return this.assertMetrics(assertionConsumer, this.DEFAULT_TIMEOUT);
    }

    public List<PrometheusMetric> assertMetrics(Consumer<List<PrometheusMetric>> assertionConsumer, Duration timeout) throws AssertionError, InterruptedException {
        this.debugLog("assertMetrics(..) validation starting.");
        Instant endTime = Instant.now().plus(timeout);
        AssertionError lastAssertionError = null;
        while (Instant.now().isBefore(endTime)) {
            try {
                List<PrometheusMetric> prometheusMetrics = this.fetchMetrics();
                assertionConsumer.accept(prometheusMetrics);
                this.debugLog("assertMetrics(..) validation passed.");
                return prometheusMetrics;
            }
            catch (AssertionError assertionError) {
                this.debugLog("assertMetrics(..) validation failed - retrying.");
                lastAssertionError = assertionError;
                Thread.sleep(1000L);
            }
        }
        throw Objects.requireNonNullElseGet(lastAssertionError, AssertionError::new);
    }

    public List<PrometheusMetric> fetchMetrics() {
        try (Client client = ClientBuilder.newClient();){
            WebTarget target = client.target(this.getPrometheusUrl());
            List<PrometheusMetric> list = this.buildPrometheusMetrics((String)target.request().get().readEntity(String.class));
            return list;
        }
    }

    @Deprecated
    public List<PrometheusMetric> fetchMetrics(String nameToMonitor) throws InterruptedException {
        return this.assertMetrics(prometheusMetrics -> Assert.assertTrue((String)String.format("Metric %s not seen in Prometheus within timeout.", nameToMonitor), (boolean)prometheusMetrics.stream().anyMatch(x -> x.getKey().contains(nameToMonitor))));
    }

    private List<PrometheusMetric> buildPrometheusMetrics(String body) {
        if (body.isEmpty()) {
            return Collections.emptyList();
        }
        String[] entries = body.split("\n");
        HashMap help = new HashMap();
        HashMap type = new HashMap();
        LinkedList<PrometheusMetric> metrics = new LinkedList<PrometheusMetric>();
        Arrays.stream(entries).forEach(e -> {
            if (e.startsWith("# HELP")) {
                this.extractMetadata(help, (String)e);
            } else if (e.startsWith("# TYPE")) {
                this.extractMetadata(type, (String)e);
            } else {
                String[] parts = e.split("[{}]");
                String key = parts[0];
                Map<String, String> tags = Arrays.stream(parts[1].split(",")).map(t -> t.split("=")).collect(Collectors.toMap(i -> i[0], i -> i[1].replaceAll("^\"", "").replaceAll("\"$", "")));
                metrics.add(new PrometheusMetric(key, tags, parts[2].trim(), (String)type.get(key), (String)help.get(key)));
            }
        });
        return metrics;
    }

    private void extractMetadata(Map<String, String> target, String source) {
        String[] parts = source.split(" ");
        target.put(parts[2], Arrays.stream(Arrays.copyOfRange(parts, 3, parts.length)).reduce("", (total, element) -> total + " " + element));
    }
}

