/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import java.util.Objects;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.wildfly.test.security.common.elytron.AbstractConfigurableElement;

public class ClientCertUndertowDomainMapper
extends AbstractConfigurableElement {
    private final String securityDomain;

    private ClientCertUndertowDomainMapper(Builder builder) {
        super(builder);
        this.securityDomain = Objects.requireNonNull(builder.securityDomain, "Security domain name has to be provided");
    }

    @Override
    public void create(CLIWrapper cli) throws Exception {
        cli.sendLine(String.format("/subsystem=elytron/provider-http-server-mechanism-factory=%s:add()", this.name));
        cli.sendLine(String.format("/subsystem=elytron/http-authentication-factory=%1$s:add(security-domain=%2$s,http-server-mechanism-factory=%1$s,mechanism-configurations=[{mechanism-name=CLIENT_CERT,mechanism-realm-configurations=[{realm-name=%1$s}]}])", this.name, this.securityDomain));
        cli.sendLine(String.format("/subsystem=undertow/application-security-domain=%1$s:add(http-authentication-factory=%1$s)", this.name));
    }

    @Override
    public void remove(CLIWrapper cli) throws Exception {
        cli.sendLine(String.format("/subsystem=undertow/application-security-domain=%s:remove()", this.name));
        cli.sendLine(String.format("/subsystem=elytron/http-authentication-factory=%s:remove()", this.name));
        cli.sendLine(String.format("/subsystem=elytron/provider-http-server-mechanism-factory=%s:remove()", this.name));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractConfigurableElement.Builder<Builder> {
        private String securityDomain;

        private Builder() {
        }

        public Builder withSecurityDomain(String securityDomain) {
            this.securityDomain = securityDomain;
            return this;
        }

        public ClientCertUndertowDomainMapper build() {
            return new ClientCertUndertowDomainMapper(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

