/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared.observability.setuptasks;

import org.jboss.arquillian.testcontainers.api.DockerRequired;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.test.shared.ServerReload;
import org.jboss.as.test.shared.observability.setuptasks.AbstractSetupTask;
import org.jboss.dmr.ModelNode;

@DockerRequired
public class OpenTelemetrySetupTask
extends AbstractSetupTask {
    protected static final String SUBSYSTEM_NAME = "opentelemetry";
    protected static final ModelNode extensionAddress = Operations.createAddress((String[])new String[]{"extension", "org.wildfly.extension.opentelemetry"});
    protected static final ModelNode subsystemAddress = Operations.createAddress((String[])new String[]{"subsystem", "opentelemetry"});
    private volatile boolean addedExtension;
    private volatile boolean addedSubsystem;

    public void setup(ManagementClient managementClient, String containerId) throws Exception {
        if (!Operations.isSuccessfulOutcome((ModelNode)this.executeRead(managementClient, extensionAddress))) {
            this.executeOp(managementClient, Operations.createAddOperation((ModelNode)extensionAddress));
            this.addedExtension = true;
        }
        if (!Operations.isSuccessfulOutcome((ModelNode)this.executeRead(managementClient, subsystemAddress))) {
            this.executeOp(managementClient, Operations.createAddOperation((ModelNode)subsystemAddress));
            this.addedSubsystem = true;
        }
        this.executeOp(managementClient, this.writeAttribute(SUBSYSTEM_NAME, "batch-delay", "1"));
        this.executeOp(managementClient, this.writeAttribute(SUBSYSTEM_NAME, "sampler-type", "on"));
        ServerReload.executeReloadAndWaitForCompletion(managementClient);
    }

    public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        if (this.addedSubsystem) {
            this.executeOp(managementClient, Operations.createRemoveOperation((ModelNode)subsystemAddress));
        }
        if (this.addedExtension) {
            this.executeOp(managementClient, Operations.createRemoveOperation((ModelNode)extensionAddress));
        }
        ServerReload.executeReloadAndWaitForCompletion(managementClient);
    }
}

