/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.subsystem.test;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.ModelVersion;

class KnownVersions {
    static final Map<String, ModelVersion> AS_CORE_MODEL_VERSION_BY_AS_VERSION;
    private static final Map<String, Map<ModelVersion, ModelVersion>> KNOWN_SUBSYSTEM_VERSIONS;

    KnownVersions() {
    }

    static ModelVersion getCoreModelVersionForSubsystemVersion(String subsystemName, ModelVersion subsystemVersion) {
        Map<ModelVersion, ModelVersion> versionMap = KNOWN_SUBSYSTEM_VERSIONS.get(subsystemName);
        if (versionMap == null) {
            return null;
        }
        return versionMap.get(subsystemVersion);
    }

    private static void addSubsystemVersion(Map<String, Map<ModelVersion, ModelVersion>> map, String subsystem, String subsystemVersion, String coreVersion) {
        ModelVersion subsystemModelVersion = ModelVersion.fromString((String)subsystemVersion);
        ModelVersion coreModelVersion = ModelVersion.fromString((String)coreVersion);
        Map<ModelVersion, ModelVersion> versionMap = map.get(subsystem);
        if (versionMap == null) {
            versionMap = new HashMap<ModelVersion, ModelVersion>();
            map.put(subsystem, versionMap);
        }
        versionMap.put(subsystemModelVersion, coreModelVersion);
    }

    static {
        HashMap<String, Map<ModelVersion, ModelVersion>> map = new HashMap<String, Map<ModelVersion, ModelVersion>>();
        String CORE_MODEL_7_1_2 = "1.2.0";
        String CORE_MODEL_7_1_3 = "1.3.0";
        String CORE_MODEL_7_2_0 = "1.4.0";
        String CORE_MODEL_8_0_0 = "2.0.0";
        KnownVersions.addSubsystemVersion(map, "configadmin", "1.0.0", "1.3.0");
        KnownVersions.addSubsystemVersion(map, "cmp", "1.0.0", "1.2.0");
        KnownVersions.addSubsystemVersion(map, "datasources", "1.1.0", "1.2.0");
        KnownVersions.addSubsystemVersion(map, "ee", "1.0.0", "1.3.0");
        KnownVersions.addSubsystemVersion(map, "jacorb", "1.1.0", "1.3.0");
        KnownVersions.addSubsystemVersion(map, "ejb3", "1.1.0", "1.2.0");
        KnownVersions.addSubsystemVersion(map, "ejb3", "1.2.0", "1.4.0");
        KnownVersions.addSubsystemVersion(map, "ejb3", "1.2.1", "1.4.0");
        KnownVersions.addSubsystemVersion(map, "infinispan", "1.3.0", "1.3.0");
        KnownVersions.addSubsystemVersion(map, "infinispan", "1.4.0", "1.4.0");
        KnownVersions.addSubsystemVersion(map, "infinispan", "1.4.1", "1.4.0");
        KnownVersions.addSubsystemVersion(map, "infinispan", "2.0.0", "2.0.0");
        KnownVersions.addSubsystemVersion(map, "jacorb", "1.1.0", "1.3.0");
        KnownVersions.addSubsystemVersion(map, "jaxr", "1.1.0", "1.2.0");
        KnownVersions.addSubsystemVersion(map, "jaxrs", "1.0.0", "1.2.0");
        KnownVersions.addSubsystemVersion(map, "jca", "1.1.0", "1.2.0");
        KnownVersions.addSubsystemVersion(map, "jca", "1.2.0", "1.4.0");
        KnownVersions.addSubsystemVersion(map, "jdr", "1.0.0", "1.2.0");
        KnownVersions.addSubsystemVersion(map, "jdr", "1.1.0", "1.4.0");
        KnownVersions.addSubsystemVersion(map, "jsr77", "1.0.0", "1.4.0");
        KnownVersions.addSubsystemVersion(map, "jmx", "1.0.0", "1.2.0");
        KnownVersions.addSubsystemVersion(map, "jmx", "1.1.0", "1.3.0");
        KnownVersions.addSubsystemVersion(map, "jgroups", "1.1.0", "1.3.0");
        KnownVersions.addSubsystemVersion(map, "jgroups", "1.2.0", "1.4.0");
        KnownVersions.addSubsystemVersion(map, "jgroups", "2.0.0", "2.0.0");
        KnownVersions.addSubsystemVersion(map, "jpa", "1.1.0", "1.3.0");
        KnownVersions.addSubsystemVersion(map, "logging", "1.1.0", "1.3.0");
        KnownVersions.addSubsystemVersion(map, "logging", "1.2.0", "1.4.0");
        KnownVersions.addSubsystemVersion(map, "mail", "1.1.0", "1.3.0");
        KnownVersions.addSubsystemVersion(map, "messaging", "1.1.0", "1.3.0");
        KnownVersions.addSubsystemVersion(map, "messaging", "1.2.0", "1.4.0");
        KnownVersions.addSubsystemVersion(map, "messaging", "1.2.1", "1.4.0");
        KnownVersions.addSubsystemVersion(map, "modcluster", "1.2.0", "1.2.0");
        KnownVersions.addSubsystemVersion(map, "modcluster", "1.2.0", "1.3.0");
        KnownVersions.addSubsystemVersion(map, "modcluster", "1.3.0", "1.4.0");
        KnownVersions.addSubsystemVersion(map, "modcluster", "2.0.0", "2.0.0");
        KnownVersions.addSubsystemVersion(map, "naming", "1.1.0", "1.3.0");
        KnownVersions.addSubsystemVersion(map, "naming", "1.2.0", "1.4.0");
        KnownVersions.addSubsystemVersion(map, "osgi", "1.0.0", "1.3.0");
        KnownVersions.addSubsystemVersion(map, "pojo", "1.0.0", "1.4.0");
        KnownVersions.addSubsystemVersion(map, "remoting", "1.1.0", "1.3.0");
        KnownVersions.addSubsystemVersion(map, "remoting", "1.2.0", "1.4.0");
        KnownVersions.addSubsystemVersion(map, "security", "1.1.0", "1.2.0");
        KnownVersions.addSubsystemVersion(map, "threads", "1.0.0", "1.2.0");
        KnownVersions.addSubsystemVersion(map, "security", "1.1.0", "1.2.0");
        KnownVersions.addSubsystemVersion(map, "security", "1.2.0", "1.4.0");
        KnownVersions.addSubsystemVersion(map, "remoting", "1.1.0", "1.3.0");
        KnownVersions.addSubsystemVersion(map, "resource-adapters", "1.1.0", "1.2.0");
        KnownVersions.addSubsystemVersion(map, "resource-adapters", "1.2.0", "1.4.0");
        KnownVersions.addSubsystemVersion(map, "sar", "1.0.0", "1.2.0");
        KnownVersions.addSubsystemVersion(map, "threads", "1.0.0", "1.2.0");
        KnownVersions.addSubsystemVersion(map, "transactions", "1.1.0", "1.2.0");
        KnownVersions.addSubsystemVersion(map, "transactions", "1.1.1", "1.3.0");
        KnownVersions.addSubsystemVersion(map, "transactions", "1.2.0", "1.4.0");
        KnownVersions.addSubsystemVersion(map, "xts", "1.1.0", "1.3.0");
        KnownVersions.addSubsystemVersion(map, "web", "1.1.0", "1.2.0");
        KnownVersions.addSubsystemVersion(map, "web", "1.1.1", "1.3.0");
        KnownVersions.addSubsystemVersion(map, "web", "1.2.0", "1.4.0");
        KnownVersions.addSubsystemVersion(map, "weld", "1.0.0", "1.2.0");
        KnownVersions.addSubsystemVersion(map, "weld", "1.0.0", "1.3.0");
        KnownVersions.addSubsystemVersion(map, "weld", "1.0.0", "1.4.0");
        KnownVersions.addSubsystemVersion(map, "webservices", "1.1.0", "1.3.0");
        KnownVersions.addSubsystemVersion(map, "webservices", "1.2.0", "1.4.0");
        KNOWN_SUBSYSTEM_VERSIONS = Collections.unmodifiableMap(map);
        HashMap<String, ModelVersion> map2 = new HashMap<String, ModelVersion>();
        map2.put("7.1.2", ModelVersion.create((int)1, (int)2, (int)0));
        map2.put("7.1.3", ModelVersion.create((int)1, (int)3, (int)0));
        AS_CORE_MODEL_VERSION_BY_AS_VERSION = Collections.unmodifiableMap(map2);
    }
}

