/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deploymentoverlay;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayDeploymentDefinition;
import org.jboss.as.server.deploymentoverlay.service.DeploymentOverlayIndexService;
import org.jboss.as.server.deploymentoverlay.service.DeploymentOverlayLinkService;
import org.jboss.as.server.deploymentoverlay.service.DeploymentOverlayPriority;
import org.jboss.as.server.deploymentoverlay.service.DeploymentOverlayService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

public class DeploymentOverlayDeploymentAdd
extends AbstractAddStepHandler {
    private final DeploymentOverlayPriority priority;

    public DeploymentOverlayDeploymentAdd(DeploymentOverlayPriority priority) {
        this.priority = priority;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : DeploymentOverlayDeploymentDefinition.attributes()) {
            attr.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        String deploymentOverlay = address.getElement(address.size() - 2).getValue();
        DeploymentOverlayDeploymentAdd.installServices(context, verificationHandler, newControllers, name, deploymentOverlay, this.priority);
    }

    static void installServices(OperationContext context, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers, String name, String deploymentOverlay, DeploymentOverlayPriority priority) {
        DeploymentOverlayLinkService service = new DeploymentOverlayLinkService(name, priority);
        ServiceName serviceName = DeploymentOverlayLinkService.SERVICE_NAME.append(new String[]{deploymentOverlay}).append(new String[]{name});
        ServiceBuilder builder = context.getServiceTarget().addService(serviceName, (Service)service).addDependency(DeploymentOverlayIndexService.SERVICE_NAME, DeploymentOverlayIndexService.class, service.getDeploymentOverlayIndexServiceInjectedValue()).addDependency(DeploymentOverlayService.SERVICE_NAME.append(new String[]{deploymentOverlay}), DeploymentOverlayService.class, service.getDeploymentOverlayServiceInjectedValue());
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        ServiceController controller = builder.install();
        if (newControllers != null) {
            newControllers.add(controller);
        }
    }
}

