/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.deployment.Attachable;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.ListAttachmentKey;

public class SimpleAttachable
implements Attachable {
    private final Map<AttachmentKey<?>, Object> attachments = new HashMap();

    @Override
    public synchronized boolean hasAttachment(AttachmentKey<?> key) {
        if (key == null) {
            return false;
        }
        return this.attachments.containsKey(key);
    }

    @Override
    public synchronized <T> T getAttachment(AttachmentKey<T> key) {
        if (key == null) {
            return null;
        }
        return key.cast(this.attachments.get(key));
    }

    @Override
    public synchronized <T> List<T> getAttachmentList(AttachmentKey<? extends List<T>> key) {
        if (key == null) {
            return null;
        }
        List<T> list = key.cast(this.attachments.get(key));
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    @Override
    public synchronized <T> T putAttachment(AttachmentKey<T> key, T value) {
        if (key == null) {
            throw ServerMessages.MESSAGES.nullAttachmentKey();
        }
        return key.cast(this.attachments.put(key, key.cast(value)));
    }

    @Override
    public synchronized <T> T removeAttachment(AttachmentKey<T> key) {
        if (key == null) {
            return null;
        }
        return key.cast(this.attachments.remove(key));
    }

    @Override
    public synchronized <T> void addToAttachmentList(AttachmentKey<AttachmentList<T>> key, T value) {
        if (key != null) {
            Map<AttachmentKey<?>, Object> attachments = this.attachments;
            AttachmentList<T> list = key.cast(attachments.get(key));
            if (list == null) {
                AttachmentList<T> newList = new AttachmentList<T>(((ListAttachmentKey)key).getValueClass());
                attachments.put(key, newList);
                newList.add(value);
            } else {
                list.add(value);
            }
        }
    }

    public synchronized Collection<AttachmentKey<?>> attachmentKeys() {
        return new HashSet(this.attachments.keySet());
    }
}

