/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt;

import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.as.server.operations.HttpManagementAddHandler;
import org.jboss.as.server.operations.HttpManagementRemoveHandler;
import org.jboss.as.server.operations.HttpManagementWriteAttributeHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class HttpManagementResourceDefinition
extends SimpleResourceDefinition {
    private static final PathElement RESOURCE_PATH = PathElement.pathElement((String)"management-interface", (String)"http-interface");
    public static final SimpleAttributeDefinition SECURITY_REALM = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-realm", ModelType.STRING, true).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false)).addAccessConstraint((AccessConstraintDefinition)new SensitiveTargetAccessConstraintDefinition(SensitivityClassification.SECURITY_REALM_REF))).build();
    public static final SimpleAttributeDefinition INTERFACE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("interface", ModelType.STRING, false).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true)).setAlternatives(new String[]{"socket-binding", "secure-socket-binding"}).addAccessConstraint((AccessConstraintDefinition)new SensitiveTargetAccessConstraintDefinition(SensitivityClassification.SOCKET_CONFIG))).setDeprecated(ModelVersion.create((int)1, (int)4))).build();
    public static final SimpleAttributeDefinition HTTP_PORT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("port", ModelType.INT, true).setAllowExpression(true).setValidator((ParameterValidator)new IntRangeValidator(0, 65535, true, true)).setAlternatives(new String[]{"socket-binding", "secure-socket-binding"}).setRequires(new String[]{"interface"}).addAccessConstraint((AccessConstraintDefinition)new SensitiveTargetAccessConstraintDefinition(SensitivityClassification.SOCKET_CONFIG))).setDeprecated(ModelVersion.create((int)1, (int)4))).build();
    public static final SimpleAttributeDefinition HTTPS_PORT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("secure-port", ModelType.INT, true).setAllowExpression(true).setValidator((ParameterValidator)new IntRangeValidator(0, 65535, true, true)).setAlternatives(new String[]{"socket-binding", "secure-socket-binding"}).setRequires(new String[]{"interface"}).addAccessConstraint((AccessConstraintDefinition)new SensitiveTargetAccessConstraintDefinition(SensitivityClassification.SOCKET_CONFIG))).setDeprecated(ModelVersion.create((int)1, (int)4))).build();
    public static final SimpleAttributeDefinition SOCKET_BINDING = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("socket-binding", ModelType.STRING, true).setXmlName(Attribute.HTTP.getLocalName()).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false)).setAlternatives(new String[]{"interface"}).addAccessConstraint((AccessConstraintDefinition)new SensitiveTargetAccessConstraintDefinition(SensitivityClassification.SOCKET_CONFIG))).build();
    public static final SimpleAttributeDefinition SECURE_SOCKET_BINDING = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("secure-socket-binding", ModelType.STRING, true).setXmlName(Attribute.HTTPS.getLocalName()).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false)).setAlternatives(new String[]{"interface"}).addAccessConstraint((AccessConstraintDefinition)new SensitiveTargetAccessConstraintDefinition(SensitivityClassification.SOCKET_CONFIG))).build();
    public static final SimpleAttributeDefinition CONSOLE_ENABLED = new SimpleAttributeDefinitionBuilder("console-enabled", ModelType.BOOLEAN, true).setXmlName(Attribute.CONSOLE_ENABLED.getLocalName()).setDefaultValue(new ModelNode(true)).build();
    public static final SimpleAttributeDefinition HTTP_UPGRADE_ENABLED = new SimpleAttributeDefinitionBuilder("http-upgrade-enabled", ModelType.BOOLEAN, true).setXmlName(Attribute.HTTP_UPGRADE_ENABLED.getLocalName()).setDefaultValue(new ModelNode(false)).build();
    public static final AttributeDefinition[] ATTRIBUTE_DEFINITIONS = new AttributeDefinition[]{INTERFACE, HTTP_PORT, HTTPS_PORT, SECURITY_REALM, SOCKET_BINDING, SECURE_SOCKET_BINDING, CONSOLE_ENABLED, HTTP_UPGRADE_ENABLED};
    public static final HttpManagementResourceDefinition INSTANCE = new HttpManagementResourceDefinition();
    private final List<AccessConstraintDefinition> accessConstraints = SensitiveTargetAccessConstraintDefinition.MANAGEMENT_INTERFACES.wrapAsList();

    private HttpManagementResourceDefinition() {
        super(RESOURCE_PATH, ServerDescriptions.getResourceDescriptionResolver("core.management.http-interface"), (OperationStepHandler)HttpManagementAddHandler.INSTANCE, (OperationStepHandler)HttpManagementRemoveHandler.INSTANCE, OperationEntry.Flag.RESTART_NONE, OperationEntry.Flag.RESTART_NONE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition attr : ATTRIBUTE_DEFINITIONS) {
            resourceRegistration.registerReadWriteAttribute(attr, null, HttpManagementWriteAttributeHandler.INSTANCE);
        }
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }
}

