/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.xml.namespace.QName;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.persistence.BackupXmlConfigurationPersister;
import org.jboss.as.controller.persistence.ConfigurationFile;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.persistence.SubsystemXmlWriterRegistry;
import org.jboss.as.server.BootstrapImpl;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.parsing.StandaloneXml;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.threads.AsyncFuture;

public interface Bootstrap {
    public AsyncFuture<ServiceContainer> bootstrap(Configuration var1, List<ServiceActivator> var2);

    public AsyncFuture<ServiceContainer> startup(Configuration var1, List<ServiceActivator> var2);

    public static final class Factory {
        private Factory() {
        }

        public static Bootstrap newInstance() {
            return new BootstrapImpl();
        }
    }

    public static interface ConfigurationPersisterFactory {
        public ExtensibleConfigurationPersister createConfigurationPersister(ServerEnvironment var1, ExecutorService var2);
    }

    public static final class Configuration {
        private final ServerEnvironment serverEnvironment;
        private final RunningModeControl runningModeControl;
        private final ExtensionRegistry extensionRegistry;
        private ModuleLoader moduleLoader = Module.getBootModuleLoader();
        private ConfigurationPersisterFactory configurationPersisterFactory;
        private long startTime = Module.getStartTime();

        public Configuration(ServerEnvironment serverEnvironment) {
            assert (serverEnvironment != null) : "serverEnvironment is null";
            this.serverEnvironment = serverEnvironment;
            this.runningModeControl = serverEnvironment.getRunningModeControl();
            this.extensionRegistry = new ExtensionRegistry(serverEnvironment.getLaunchType().getProcessType(), this.runningModeControl);
        }

        public ServerEnvironment getServerEnvironment() {
            return this.serverEnvironment;
        }

        RunningModeControl getRunningModeControl() {
            return this.runningModeControl;
        }

        public ExtensionRegistry getExtensionRegistry() {
            return this.extensionRegistry;
        }

        public ModuleLoader getModuleLoader() {
            return this.moduleLoader;
        }

        public void setModuleLoader(ModuleLoader moduleLoader) {
            assert (moduleLoader != null) : "moduleLoader is null";
            this.moduleLoader = moduleLoader;
        }

        public synchronized ConfigurationPersisterFactory getConfigurationPersisterFactory() {
            if (this.configurationPersisterFactory == null) {
                this.configurationPersisterFactory = new ConfigurationPersisterFactory(){

                    @Override
                    public ExtensibleConfigurationPersister createConfigurationPersister(ServerEnvironment serverEnvironment, ExecutorService executorService) {
                        ConfigurationFile configurationFile = serverEnvironment.getServerConfigurationFile();
                        if (Configuration.this.runningModeControl.isReloaded()) {
                            configurationFile.resetBootFile(Configuration.this.runningModeControl.isUseCurrentConfig());
                        }
                        QName rootElement = new QName(Namespace.CURRENT.getUriString(), "server");
                        StandaloneXml parser = new StandaloneXml(Module.getBootModuleLoader(), executorService, Configuration.this.extensionRegistry);
                        BackupXmlConfigurationPersister persister = new BackupXmlConfigurationPersister(configurationFile, rootElement, (XMLElementReader)parser, (XMLElementWriter)parser);
                        for (Namespace namespace : Namespace.domainValues()) {
                            if (namespace.equals((Object)Namespace.CURRENT)) continue;
                            persister.registerAdditionalRootElement(new QName(namespace.getUriString(), "server"), (XMLElementReader)parser);
                        }
                        Configuration.this.extensionRegistry.setWriterRegistry((SubsystemXmlWriterRegistry)persister);
                        return persister;
                    }
                };
            }
            return this.configurationPersisterFactory;
        }

        public synchronized void setConfigurationPersisterFactory(ConfigurationPersisterFactory configurationPersisterFactory) {
            this.configurationPersisterFactory = configurationPersisterFactory;
        }

        public long getStartTime() {
            return this.startTime;
        }
    }
}

