/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.rts.jaxrs;

import jakarta.annotation.Priority;
import jakarta.transaction.SystemException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import org.wildfly.extension.rts.logging.RTSLogger;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.LocalTransactionContext;

@Provider
@Priority(value=4920)
public class ImportWildflyClientGlobalTransactionFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    public void filter(ContainerRequestContext requestContext) throws IOException {
        try {
            LocalTransactionContext.getCurrent().importProviderTransaction();
        }
        catch (SystemException se) {
            throw RTSLogger.ROOT_LOGGER.failueOnImportingGlobalTransactionFromWildflyClient(se);
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        try {
            if (ContextTransactionManager.getInstance() != null && ContextTransactionManager.getInstance().getStatus() != 6) {
                ContextTransactionManager.getInstance().suspend();
            }
        }
        catch (SystemException se) {
            RTSLogger.ROOT_LOGGER.cannotGetTransactionStatus(responseContext, se);
        }
    }
}

