/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.HttpUpgradeHandshake;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import org.jboss.as.remoting.RemotingMessages;

public class SimpleHttpUpgradeHandshake
implements HttpUpgradeHandshake {
    private final String keyHeader;
    private final String magicNumber;
    private final String acceptHeader;

    public SimpleHttpUpgradeHandshake(String magicNumber, String keyHeader, String acceptHeader) {
        this.keyHeader = keyHeader;
        this.magicNumber = magicNumber;
        this.acceptHeader = acceptHeader;
    }

    public boolean handleUpgrade(HttpServerExchange exchange) throws IOException {
        String secretKey = exchange.getRequestHeaders().getFirst(this.keyHeader);
        if (secretKey == null) {
            throw RemotingMessages.MESSAGES.upgradeRequestMissingKey();
        }
        String response = this.createExpectedResponse(this.magicNumber, secretKey);
        exchange.getResponseHeaders().put(HttpString.tryFromString((String)this.acceptHeader), response);
        return true;
    }

    private String createExpectedResponse(String magicNumber, String secretKey) throws IOException {
        try {
            String concat = secretKey + magicNumber;
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            digest.update(concat.getBytes("UTF-8"));
            byte[] bytes = digest.digest();
            return FlexBase64.encodeString(bytes, false);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    private static class FlexBase64 {
        private static final byte[] ENCODING_TABLE;
        private static final byte[] DECODING_TABLE;
        private static final Constructor<String> STRING_CONSTRUCTOR;

        private FlexBase64() {
        }

        public static String encodeString(byte[] source, boolean wrap) {
            return FlexBase64.encodeString(source, 0, source.length, wrap);
        }

        private static String encodeString(byte[] source, int pos, int limit, boolean wrap) {
            int olimit;
            int remainder = (olimit = limit - pos) % 3;
            olimit = (olimit + (remainder == 0 ? 0 : 3 - remainder)) / 3 * 4;
            char[] target = new char[olimit += wrap ? olimit / 76 * 2 + 2 : 0];
            int opos = 0;
            int last = 0;
            int count = 0;
            int state = 0;
            byte[] ENCODING_TABLE = FlexBase64.ENCODING_TABLE;
            while (limit > pos) {
                int b = source[pos++] & 0xFF;
                target[opos++] = (char)ENCODING_TABLE[b >>> 2];
                last = (b & 3) << 4;
                if (pos >= limit) {
                    state = 1;
                    break;
                }
                b = source[pos++] & 0xFF;
                target[opos++] = (char)ENCODING_TABLE[last | b >>> 4];
                last = (b & 0xF) << 2;
                if (pos >= limit) {
                    state = 2;
                    break;
                }
                b = source[pos++] & 0xFF;
                target[opos++] = (char)ENCODING_TABLE[last | b >>> 6];
                target[opos++] = (char)ENCODING_TABLE[b & 0x3F];
                if (!wrap || (count += 4) < 76) continue;
                count = 0;
                target[opos++] = 13;
                target[opos++] = 10;
            }
            FlexBase64.complete(target, opos, state, last, wrap);
            try {
                if (STRING_CONSTRUCTOR != null) {
                    return STRING_CONSTRUCTOR.newInstance(target, Boolean.TRUE);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return new String(target);
        }

        private static int complete(char[] target, int pos, int state, int last, boolean wrap) {
            if (state > 0) {
                target[pos++] = (char)ENCODING_TABLE[last];
                for (int i = state; i < 3; ++i) {
                    target[pos++] = 61;
                }
            }
            if (wrap) {
                target[pos++] = 13;
                target[pos++] = 10;
            }
            return pos;
        }

        static {
            DECODING_TABLE = new byte[80];
            try {
                ENCODING_TABLE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes("ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException();
            }
            for (int i = 0; i < ENCODING_TABLE.length; ++i) {
                int v = (ENCODING_TABLE[i] & 0xFF) - 43;
                FlexBase64.DECODING_TABLE[v] = (byte)(i + 1);
            }
            Constructor c = null;
            try {
                PrivilegedExceptionAction<Constructor<String>> runnable = new PrivilegedExceptionAction<Constructor<String>>(){

                    @Override
                    public Constructor<String> run() throws Exception {
                        Constructor<String> c = String.class.getDeclaredConstructor(char[].class, Boolean.TYPE);
                        c.setAccessible(true);
                        return c;
                    }
                };
                c = System.getSecurityManager() != null ? AccessController.doPrivileged(runnable) : (Constructor)runnable.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            STRING_CONSTRUCTOR = c;
        }
    }
}

