/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RestartParentResourceAddHandler;
import org.jboss.as.controller.RestartParentResourceRemoveHandler;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.remoting.ConnectorAdd;
import org.jboss.as.remoting.RemotingExtension;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;

public class PropertyResource
extends SimpleResourceDefinition {
    static final PathElement PATH = PathElement.pathElement((String)"property");
    static final PropertyResource INSTANCE_CONNECTOR = new PropertyResource("connector");
    static final PropertyResource INSTANCE_HTTP_CONNECTOR = new PropertyResource("http-connector");
    static final SimpleAttributeDefinition VALUE = SimpleAttributeDefinitionBuilder.create((String)"value", (ModelType)ModelType.STRING).setDefaultValue(null).setAllowNull(true).setAllowExpression(true).build();
    private final String parent;

    protected PropertyResource(String parent) {
        super(PATH, RemotingExtension.getResourceDescriptionResolver("property"), (OperationStepHandler)new PropertyAdd(parent), (OperationStepHandler)new PropertyRemove(parent));
        this.parent = parent;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)VALUE, null, (OperationStepHandler)new PropertyWriteAttributeHandler(this.parent));
    }

    private static void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        ConnectorAdd.INSTANCE.launchServices(context, parentAddress.getLastElement().getValue(), parentModel, verificationHandler, null);
    }

    private static ServiceName getParentServiceName(PathAddress parentAddress) {
        return RemotingServices.serverServiceName(parentAddress.getLastElement().getValue());
    }

    private static class PropertyRemove
    extends RestartParentResourceRemoveHandler {
        private PropertyRemove(String parent) {
            super(parent);
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
            PropertyResource.recreateParentService(context, parentAddress, parentModel, verificationHandler);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return PropertyResource.getParentServiceName(parentAddress);
        }
    }

    private static class PropertyAdd
    extends RestartParentResourceAddHandler {
        private PropertyAdd(String parent) {
            super(parent);
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            VALUE.validateAndSet(operation, model);
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
            PropertyResource.recreateParentService(context, parentAddress, parentModel, verificationHandler);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return PropertyResource.getParentServiceName(parentAddress);
        }
    }

    private static class PropertyWriteAttributeHandler
    extends RestartParentWriteAttributeHandler {
        public PropertyWriteAttributeHandler(String parent) {
            super(parent, new AttributeDefinition[]{VALUE});
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
            PropertyResource.recreateParentService(context, parentAddress, parentModel, verificationHandler);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return PropertyResource.getParentServiceName(parentAddress);
        }
    }
}

