/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ModelTestModelDescriptionValidator {
    private static final Map<String, ArbitraryDescriptorValidator> VALID_RESOURCE_KEYS;
    private static final Map<String, ArbitraryDescriptorValidator> VALID_CHILD_TYPE_KEYS;
    private static final Map<String, AttributeOrParameterArbitraryDescriptorValidator> VALID_ATTRIBUTE_KEYS;
    private static final Map<String, ArbitraryDescriptorValidator> VALID_OPERATION_KEYS;
    private static final Map<String, AttributeOrParameterArbitraryDescriptorValidator> VALID_PARAMETER_KEYS;
    private final List<ValidationFailure> errors;
    private final ModelNode address;
    private final ModelNode description;
    private final ValidationConfiguration validationConfiguration;

    public ModelTestModelDescriptionValidator(ModelNode address, ModelNode description, ValidationConfiguration validationConfiguration) {
        this(new ArrayList<ValidationFailure>(), address, description, validationConfiguration);
    }

    private ModelTestModelDescriptionValidator(List<ValidationFailure> errors, ModelNode address, ModelNode description, ValidationConfiguration validationConfiguration) {
        if (address == null) {
            throw new IllegalArgumentException("Null address");
        }
        if (description == null) {
            throw new IllegalArgumentException("Null address");
        }
        this.errors = errors;
        this.address = address;
        this.description = description;
        this.validationConfiguration = validationConfiguration == null ? new ValidationConfiguration() : validationConfiguration;
    }

    public List<ValidationFailure> validateResources() {
        if (!this.description.isDefined()) {
            this.errors.add(new MessageValidationFailure("No model", this.address));
            return this.errors;
        }
        for (String key : this.description.keys()) {
            ArbitraryDescriptorValidator validator = VALID_RESOURCE_KEYS.get(key);
            if (validator == null) {
                this.errors.add(new MessageValidationFailure("Invalid key '" + key + "'", this.address));
                continue;
            }
            if (this.description.hasDefined(key)) {
                String error = validator.validate(this.description, key);
                if (error == null) continue;
                this.errors.add(new MessageValidationFailure(error, this.address));
                continue;
            }
            if (key.equals("operations") || key.equals("children")) continue;
            this.errors.add(new MessageValidationFailure("Empty key '" + key + "'", this.address));
        }
        if (!this.description.hasDefined("description")) {
            this.errors.add(new MessageValidationFailure("Missing description", this.address));
        }
        if (this.description.hasDefined("attributes")) {
            this.validateAttributes(this.description.get("attributes"));
        }
        if (this.description.hasDefined("operations")) {
            this.validateOperations(this.description.get("operations"));
        }
        if (this.description.hasDefined("children")) {
            this.validateChildren(this.description.get("children"));
        }
        return this.errors;
    }

    private void validateAttributes(ModelNode attributes) {
        for (String key : attributes.keys()) {
            ModelNode attribute = attributes.get(key);
            AttributeValidationElement attributeValidationElement = new AttributeValidationElement(key);
            this.validateAttributeOrParameter(attributeValidationElement, attribute);
        }
    }

    private void validateOperations(ModelNode operations) {
        for (String key : operations.keys()) {
            OperationValidationElement operation = new OperationValidationElement(key);
            ModelNode op = operations.get(key);
            operation.validateKeys(op);
            if (!op.hasDefined("description")) {
                this.errors.add(operation.createValidationFailure("Missing description"));
            }
            if (!key.equals(op.get("operation-name").asString())) {
                this.errors.add(operation.createValidationFailure("Expected operation-name '" + key + "'"));
            }
            if (op.hasDefined("request-properties")) {
                for (String param : op.get("request-properties").keys()) {
                    ModelNode paramNode = op.get(new String[]{"request-properties", param});
                    OperationParameterValidationElement parameterValidationElement = new OperationParameterValidationElement(operation, param);
                    this.validateAttributeOrParameter(parameterValidationElement, paramNode);
                }
            }
            if (!op.hasDefined("reply-properties")) continue;
            ModelNode reply = op.get("reply-properties");
            OperationParameterValidationElement parameterValidationElement = new OperationParameterValidationElement(operation, "reply-properties");
            this.validateAttributeOrParameter(parameterValidationElement, reply);
        }
    }

    private void validateChildren(ModelNode children) {
        for (String type : children.keys()) {
            ModelNode childType;
            ModelNode typeNode = children.get(type);
            for (String key : typeNode.keys()) {
                ArbitraryDescriptorValidator validator = VALID_CHILD_TYPE_KEYS.get(key);
                if (validator == null) {
                    this.errors.add(new MessageValidationFailure("Invalid key '" + key + "' found for child type '" + type + "'", this.address));
                    continue;
                }
                if (typeNode.hasDefined(key)) {
                    String error = validator.validate(typeNode, key);
                    if (error == null) continue;
                    this.errors.add(new MessageValidationFailure(error, this.address));
                    continue;
                }
                if (key.equals("model-description")) continue;
                this.errors.add(new MessageValidationFailure("Empty key '" + key + "' found for child type '" + type + "'", this.address));
            }
            if (!typeNode.hasDefined("description")) {
                this.errors.add(new MessageValidationFailure("Missing description for child type '" + type + "' on ModelNode '" + typeNode.toString() + "'", this.address));
            }
            if (!(childType = typeNode.get("model-description")).isDefined()) {
                this.errors.add(new MessageValidationFailure("No model description for child '" + type + "'", this.address));
                continue;
            }
            for (String child : childType.keys()) {
                ModelNode childAddress = this.address.clone();
                childAddress.add(type, child);
                ModelTestModelDescriptionValidator childValidator = new ModelTestModelDescriptionValidator(this.errors, childAddress, childType.get(child), this.validationConfiguration);
                childValidator.validateResources();
            }
        }
    }

    private void validateAttributeOrParameter(AttributeValidationElement validationElement, ModelNode rawDescription) {
        boolean reply = validationElement.name.equals("reply-properties");
        if (!rawDescription.hasDefined("description") && !reply) {
            this.errors.add(validationElement.createValidationFailure("Missing description"));
        }
        if (reply && rawDescription.isDefined() && rawDescription.keys().size() == 0) {
            return;
        }
        this.validateAttributeOrParameter(validationElement, rawDescription, rawDescription);
    }

    private void validateAttributeOrParameter(AttributeValidationElement validationElement, ModelNode rawDescription, ModelNode currentDescription) {
        ModelType type;
        if (!currentDescription.isDefined()) {
            this.errors.add(validationElement.createValidationFailure("Undefined description " + currentDescription.asString()));
        }
        ModelNode typeNode = currentDescription.hasDefined("type") ? currentDescription.get("type") : null;
        ModelNode valueTypeNode = currentDescription.hasDefined("value-type") ? currentDescription.get("value-type") : null;
        try {
            type = typeNode.asType();
        }
        catch (Exception e) {
            this.errors.add(validationElement.createValidationFailure("Invalid type " + currentDescription.asString()));
            return;
        }
        if (type == ModelType.OBJECT || type == ModelType.LIST) {
            if (valueTypeNode == null && !validationElement.allowNullValueTypeForObject()) {
                this.errors.add(validationElement.createValidationFailure("No value-type for type=" + type + " " + currentDescription.asString()));
                return;
            }
        } else if (valueTypeNode != null) {
            this.errors.add(validationElement.createValidationFailure("Unnecessary value-type for type=" + type + " " + currentDescription.asString()));
        }
        if (valueTypeNode != null) {
            try {
                valueTypeNode.asType();
            }
            catch (Exception e) {
                Set keys;
                try {
                    keys = valueTypeNode.keys();
                }
                catch (Exception e1) {
                    this.errors.add(validationElement.createValidationFailure("Could not get keys for value-type for type=" + type + " " + currentDescription.asString()));
                    return;
                }
                for (String key : keys) {
                    this.validateAttributeOrParameter(validationElement, rawDescription, valueTypeNode.get(key));
                }
            }
        }
        validationElement.validateKeys(type, currentDescription);
    }

    static {
        HashMap<String, ArbitraryDescriptorValidator> validResourceKeys = new HashMap<String, ArbitraryDescriptorValidator>();
        validResourceKeys.put("description", NullDescriptorValidator.INSTANCE);
        validResourceKeys.put("head-comment-allowed", BooleanDescriptorValidator.INSTANCE);
        validResourceKeys.put("tail-comment-allowed", BooleanDescriptorValidator.INSTANCE);
        validResourceKeys.put("namespace", NullDescriptorValidator.INSTANCE);
        validResourceKeys.put("attributes", NullDescriptorValidator.INSTANCE);
        validResourceKeys.put("operations", NullDescriptorValidator.INSTANCE);
        validResourceKeys.put("children", NullDescriptorValidator.INSTANCE);
        validResourceKeys.put("deprecated", DeprecatedDescriptorValidator.INSTANCE);
        validResourceKeys.put("access-constraints", AccessConstraintValidator.INSTANCE);
        VALID_RESOURCE_KEYS = Collections.unmodifiableMap(validResourceKeys);
        HashMap<String, ArbitraryDescriptorValidator> validChildTypeKeys = new HashMap<String, ArbitraryDescriptorValidator>();
        validChildTypeKeys.put("description", NullDescriptorValidator.INSTANCE);
        validChildTypeKeys.put("model-description", NullDescriptorValidator.INSTANCE);
        validChildTypeKeys.put("min-occurs", SimpleIntDescriptorValidator.INSTANCE);
        validChildTypeKeys.put("max-occurs", SimpleIntDescriptorValidator.INSTANCE);
        validChildTypeKeys.put("allowed", StringListValidator.INSTANCE);
        VALID_CHILD_TYPE_KEYS = Collections.unmodifiableMap(validChildTypeKeys);
        HashMap<String, Object> paramAndAttributeKeys = new HashMap<String, Object>();
        paramAndAttributeKeys.put("description", NullDescriptorValidator.INSTANCE);
        paramAndAttributeKeys.put("required", BooleanDescriptorValidator.INSTANCE);
        paramAndAttributeKeys.put("nillable", BooleanDescriptorValidator.INSTANCE);
        paramAndAttributeKeys.put("value-type", NullDescriptorValidator.INSTANCE);
        paramAndAttributeKeys.put("type", NullDescriptorValidator.INSTANCE);
        paramAndAttributeKeys.put("alternatives", StringListValidator.INSTANCE);
        paramAndAttributeKeys.put("requires", StringListValidator.INSTANCE);
        paramAndAttributeKeys.put("min", NumericDescriptorValidator.INSTANCE);
        paramAndAttributeKeys.put("max", NumericDescriptorValidator.INSTANCE);
        paramAndAttributeKeys.put("min-length", LengthDescriptorValidator.INSTANCE);
        paramAndAttributeKeys.put("max-length", LengthDescriptorValidator.INSTANCE);
        paramAndAttributeKeys.put("default", NullDescriptorValidator.INSTANCE);
        paramAndAttributeKeys.put("allowed", StringListValidator.INSTANCE);
        paramAndAttributeKeys.put("unit", NumericDescriptorValidator.INSTANCE);
        paramAndAttributeKeys.put("expressions-allowed", BooleanDescriptorValidator.INSTANCE);
        paramAndAttributeKeys.put("deprecated", DeprecatedDescriptorValidator.INSTANCE);
        HashMap<String, Object> validAttributeKeys = new HashMap<String, Object>();
        validAttributeKeys.putAll(paramAndAttributeKeys);
        validAttributeKeys.put("access-type", AccessTypeDescriptorValidator.INSTANCE);
        validAttributeKeys.put("head-comment-allowed", BooleanDescriptorValidator.INSTANCE);
        validAttributeKeys.put("tail-comment-allowed", BooleanDescriptorValidator.INSTANCE);
        validAttributeKeys.put("storage", StorageDescriptorValidator.INSTANCE);
        validAttributeKeys.put("restart-required", NullDescriptorValidator.INSTANCE);
        validAttributeKeys.put("deprecated", DeprecatedDescriptorValidator.INSTANCE);
        validAttributeKeys.put("access-constraints", AccessConstraintValidator.INSTANCE);
        VALID_ATTRIBUTE_KEYS = Collections.unmodifiableMap(validAttributeKeys);
        HashMap<String, ArbitraryDescriptorValidator> validOperationKeys = new HashMap<String, ArbitraryDescriptorValidator>();
        validOperationKeys.put("description", NullDescriptorValidator.INSTANCE);
        validOperationKeys.put("operation-name", NullDescriptorValidator.INSTANCE);
        validOperationKeys.put("request-properties", NullDescriptorValidator.INSTANCE);
        validOperationKeys.put("reply-properties", NullDescriptorValidator.INSTANCE);
        validOperationKeys.put("deprecated", DeprecatedDescriptorValidator.INSTANCE);
        validOperationKeys.put("access-constraints", AccessConstraintValidator.INSTANCE);
        VALID_OPERATION_KEYS = Collections.unmodifiableMap(validOperationKeys);
        HashMap<String, Object> validParameterKeys = new HashMap<String, Object>();
        validParameterKeys.putAll(paramAndAttributeKeys);
        VALID_PARAMETER_KEYS = Collections.unmodifiableMap(validParameterKeys);
    }

    private class OperationParameterValidationElement
    extends AttributeValidationElement {
        private final OperationValidationElement operation;

        OperationParameterValidationElement(OperationValidationElement operation, String name) {
            super(name, VALID_PARAMETER_KEYS);
            this.operation = operation;
        }

        @Override
        public String toString() {
            return "Parameter '" + this.name + "' in operation " + this.operation.getName() + "' @" + ModelTestModelDescriptionValidator.this.address;
        }

        @Override
        ValidationFailure createValidationFailure(String message) {
            return new OperationParameterValidationFailure(message, ModelTestModelDescriptionValidator.this.address, this.operation.getName(), this.name);
        }

        @Override
        AttributeOrParameterArbitraryDescriptorValidator getExtraValidator(String key) {
            return ModelTestModelDescriptionValidator.this.validationConfiguration.getOperationParameterValidator(ModelTestModelDescriptionValidator.this.address, this.operation.getName(), this.name, key);
        }

        @Override
        boolean allowNullValueTypeForObject() {
            return ModelTestModelDescriptionValidator.this.validationConfiguration.isAllowNullValueTypeForOperationParameter(ModelTestModelDescriptionValidator.this.address, this.operation.getName(), this.name);
        }
    }

    private class AttributeValidationElement
    extends ValidationElement {
        final Map<String, AttributeOrParameterArbitraryDescriptorValidator> standardValidators;

        AttributeValidationElement(String name) {
            this(name, VALID_ATTRIBUTE_KEYS);
        }

        public AttributeValidationElement(String name, Map<String, AttributeOrParameterArbitraryDescriptorValidator> standardValidators) {
            super(name);
            this.standardValidators = standardValidators;
        }

        public String toString() {
            return "Attribute '" + this.name + "' @" + ModelTestModelDescriptionValidator.this.address;
        }

        void validateKeys(ModelType currentType, ModelNode description) {
            for (String attrKey : description.keys()) {
                AttributeOrParameterArbitraryDescriptorValidator validator = this.standardValidators.get(attrKey);
                if (validator == null) {
                    validator = this.getExtraValidator(attrKey);
                    if (validator != null) continue;
                    ModelTestModelDescriptionValidator.this.errors.add(this.createValidationFailure("Invalid key '" + attrKey + "'"));
                    continue;
                }
                if (description.hasDefined(attrKey)) {
                    String error = validator.validate(currentType, description, attrKey);
                    if (error == null) continue;
                    ModelTestModelDescriptionValidator.this.errors.add(this.createValidationFailure(error));
                    continue;
                }
                ModelTestModelDescriptionValidator.this.errors.add(this.createValidationFailure("Empty key '" + attrKey + "'"));
            }
        }

        @Override
        ValidationFailure createValidationFailure(String message) {
            return new AttributeValidationFailure(message, ModelTestModelDescriptionValidator.this.address, this.name);
        }

        AttributeOrParameterArbitraryDescriptorValidator getExtraValidator(String key) {
            return ModelTestModelDescriptionValidator.this.validationConfiguration.getAttributeValidator(ModelTestModelDescriptionValidator.this.address, this.name, key);
        }

        boolean allowNullValueTypeForObject() {
            return ModelTestModelDescriptionValidator.this.validationConfiguration.isAllowNullValueTypeForAttribute(ModelTestModelDescriptionValidator.this.address, this.name);
        }
    }

    private class OperationValidationElement
    extends ValidationElement {
        OperationValidationElement(String name) {
            super(name);
        }

        String getName() {
            return this.name;
        }

        public String toString() {
            return "Operation '" + this.name + "' @" + ModelTestModelDescriptionValidator.this.address;
        }

        void validateKeys(ModelNode description) {
            if (!description.isDefined()) {
                ModelTestModelDescriptionValidator.this.errors.add(this.createValidationFailure("Missing description for operation"));
                return;
            }
            for (String opKey : description.keys()) {
                ArbitraryDescriptorValidator validator = (ArbitraryDescriptorValidator)VALID_OPERATION_KEYS.get(opKey);
                if (validator == null) {
                    ModelTestModelDescriptionValidator.this.errors.add(this.createValidationFailure("Invalid key '" + opKey + "'"));
                    continue;
                }
                if (description.hasDefined(opKey)) {
                    String error = validator.validate(description, opKey);
                    if (error == null) continue;
                    ModelTestModelDescriptionValidator.this.errors.add(this.createValidationFailure(error));
                    continue;
                }
                ModelTestModelDescriptionValidator.this.errors.add(this.createValidationFailure("Empty key '" + opKey + "'"));
            }
        }

        @Override
        ValidationFailure createValidationFailure(String message) {
            return new OperationValidationFailure(message, ModelTestModelDescriptionValidator.this.address, this.name);
        }
    }

    private abstract class ValidationElement {
        protected final String name;

        public ValidationElement(String name) {
            this.name = name;
        }

        abstract ValidationFailure createValidationFailure(String var1);
    }

    private static class AttributeValidationFailure
    extends MessageValidationFailure {
        private final String attributeName;

        private AttributeValidationFailure(String message, ModelNode address, String attributeName) {
            super(message, address);
            this.attributeName = attributeName;
        }

        @Override
        public String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public String toString() {
            return this.message + " for attribute '" + this.attributeName + "'" + this.address;
        }
    }

    private static class OperationParameterValidationFailure
    extends OperationValidationFailure {
        private final String parameterName;

        OperationParameterValidationFailure(String message, ModelNode address, String operationName, String parameterName) {
            super(message, address, operationName);
            this.parameterName = parameterName;
        }

        @Override
        public String getOperationParameterName() {
            return this.parameterName;
        }

        @Override
        public String toString() {
            return this.message + " for operation parameter '" + this.operationName + "." + this.parameterName + "' @" + this.address;
        }
    }

    private static class OperationValidationFailure
    extends MessageValidationFailure {
        protected final String operationName;

        OperationValidationFailure(String message, ModelNode address, String operationName) {
            super(message, address);
            this.operationName = operationName;
        }

        @Override
        public String getOperationName() {
            return this.operationName;
        }

        @Override
        public String toString() {
            return this.message + " for operation '" + this.operationName + "' @" + this.address;
        }
    }

    static class MessageValidationFailure
    extends ValidationFailure {
        protected final String message;
        protected final ModelNode address;

        protected MessageValidationFailure(String message, ModelNode address) {
            this.message = message;
            this.address = address;
        }

        @Override
        public String toString() {
            return this.message + " @" + this.address;
        }

        @Override
        public final ModelNode getAddress() {
            return this.address;
        }

        @Override
        public String getOperationName() {
            return null;
        }

        @Override
        public String getOperationParameterName() {
            return null;
        }

        @Override
        public String getAttributeName() {
            return null;
        }
    }

    public static abstract class ValidationFailure {
        public abstract String toString();

        public abstract ModelNode getAddress();

        public abstract String getOperationName();

        public abstract String getOperationParameterName();

        public abstract String getAttributeName();
    }

    public static class ValidationConfiguration {
        private Map<ModelNode, Set<String>> nullValueTypeAttributes = new HashMap<ModelNode, Set<String>>();
        private Map<ModelNode, Map<String, Set<String>>> nullValueTypeOperations = new HashMap<ModelNode, Map<String, Set<String>>>();
        private Map<ModelNode, Map<String, Map<String, AttributeOrParameterArbitraryDescriptorValidator>>> attributeDescriptors = new HashMap<ModelNode, Map<String, Map<String, AttributeOrParameterArbitraryDescriptorValidator>>>();
        private Map<ModelNode, Map<String, Map<String, Map<String, AttributeOrParameterArbitraryDescriptorValidator>>>> operationParameterDescriptors = new HashMap<ModelNode, Map<String, Map<String, Map<String, AttributeOrParameterArbitraryDescriptorValidator>>>>();

        public void allowNullValueTypeForAttribute(ModelNode address, String name) {
            Set<String> names = this.nullValueTypeAttributes.get(address);
            if (names == null) {
                names = new HashSet<String>();
                this.nullValueTypeAttributes.put(address, names);
            }
            names.add(name);
        }

        public void allowNullValueTypeForOperation(ModelNode address, String operation) {
            this.allowNullValueTypeForOperationParameter(address, operation, "*");
        }

        public void allowNullValueTypeForOperationReplyProperties(ModelNode address, String operation) {
            this.allowNullValueTypeForOperationParameter(address, operation, "reply-properties");
        }

        public void allowNullValueTypeForOperationParameter(ModelNode address, String operation, String param) {
            Set<String> params;
            Map<String, Set<String>> names = this.nullValueTypeOperations.get(address);
            if (names == null) {
                names = new HashMap<String, Set<String>>();
                this.nullValueTypeOperations.put(address, names);
            }
            if ((params = names.get(operation)) == null) {
                params = new HashSet<String>();
                names.put(operation, params);
            }
            params.add(param);
        }

        public void registerAttributeArbitraryDescriptor(ModelNode address, String name, String descriptor, AttributeOrParameterArbitraryDescriptorValidator validator) {
            Map<String, AttributeOrParameterArbitraryDescriptorValidator> descriptors;
            Map<String, Map<String, AttributeOrParameterArbitraryDescriptorValidator>> byName = this.attributeDescriptors.get(address);
            if (byName == null) {
                byName = new HashMap<String, Map<String, AttributeOrParameterArbitraryDescriptorValidator>>();
                this.attributeDescriptors.put(address, byName);
            }
            if ((descriptors = byName.get(name)) == null) {
                descriptors = new HashMap<String, AttributeOrParameterArbitraryDescriptorValidator>();
                byName.put(name, descriptors);
            }
            descriptors.put(descriptor, validator == null ? NullDescriptorValidator.INSTANCE : validator);
        }

        public void registerArbitraryDescriptorForOperation(ModelNode address, String operation, String descriptor, AttributeOrParameterArbitraryDescriptorValidator validator) {
            this.registerArbitraryDescriptorForOperationParameter(address, operation, "*", descriptor, validator);
        }

        public void registerArbitraryDescriptorForOperationReplyProperties(ModelNode address, String operation, String descriptor, AttributeOrParameterArbitraryDescriptorValidator validator) {
            this.registerArbitraryDescriptorForOperationParameter(address, operation, "reply-properties", descriptor, validator);
        }

        public void registerArbitraryDescriptorForOperationParameter(ModelNode address, String operation, String parameter, String descriptor, AttributeOrParameterArbitraryDescriptorValidator validator) {
            Map<String, AttributeOrParameterArbitraryDescriptorValidator> descriptors;
            Map<String, Map<String, AttributeOrParameterArbitraryDescriptorValidator>> params;
            Map<String, Map<String, Map<String, AttributeOrParameterArbitraryDescriptorValidator>>> byName = this.operationParameterDescriptors.get(address);
            if (byName == null) {
                byName = new HashMap<String, Map<String, Map<String, AttributeOrParameterArbitraryDescriptorValidator>>>();
                this.operationParameterDescriptors.put(address, byName);
            }
            if ((params = byName.get(operation)) == null) {
                params = new HashMap<String, Map<String, AttributeOrParameterArbitraryDescriptorValidator>>();
                byName.put(operation, params);
            }
            if ((descriptors = params.get(parameter)) == null) {
                descriptors = new HashMap<String, AttributeOrParameterArbitraryDescriptorValidator>();
                params.put(parameter, descriptors);
            }
            descriptors.put(descriptor, validator == null ? NullDescriptorValidator.INSTANCE : validator);
        }

        private AttributeOrParameterArbitraryDescriptorValidator getAttributeValidator(ModelNode address, String name, String descriptor) {
            Map<String, Map<String, AttributeOrParameterArbitraryDescriptorValidator>> byName = this.attributeDescriptors.get(address);
            if (byName == null) {
                return null;
            }
            Map<String, AttributeOrParameterArbitraryDescriptorValidator> descriptors = byName.get(name);
            if (descriptors == null) {
                return null;
            }
            return descriptors.get(descriptor);
        }

        private AttributeOrParameterArbitraryDescriptorValidator getOperationParameterValidator(ModelNode address, String operation, String parameter, String descriptor) {
            AttributeOrParameterArbitraryDescriptorValidator validator;
            Map<String, Map<String, Map<String, AttributeOrParameterArbitraryDescriptorValidator>>> byName = this.operationParameterDescriptors.get(address);
            if (byName == null) {
                return null;
            }
            Map<String, Map<String, AttributeOrParameterArbitraryDescriptorValidator>> params = byName.get(operation);
            if (params == null) {
                return null;
            }
            Map<String, AttributeOrParameterArbitraryDescriptorValidator> descriptors = params.get(parameter);
            if (descriptors != null && (validator = descriptors.get(descriptor)) != null) {
                return validator;
            }
            descriptors = params.get("*");
            if (descriptors == null) {
                return null;
            }
            return descriptors.get(descriptor);
        }

        private boolean isAllowNullValueTypeForOperationParameter(ModelNode address, String operation, String param) {
            Map<String, Set<String>> operations = this.nullValueTypeOperations.get(address);
            if (operations == null) {
                return false;
            }
            Set<String> params = operations.get(operation);
            if (params == null) {
                return false;
            }
            return params.contains(param) || params.contains("*");
        }

        private boolean isAllowNullValueTypeForAttribute(ModelNode address, String name) {
            Set<String> names = this.nullValueTypeAttributes.get(address);
            if (names == null) {
                return false;
            }
            return names.contains(name);
        }
    }

    private static class StringListValidator
    implements ArbitraryDescriptorValidator,
    AttributeOrParameterArbitraryDescriptorValidator {
        static final StringListValidator INSTANCE = new StringListValidator();

        private StringListValidator() {
        }

        @Override
        public String validate(ModelType currentType, ModelNode currentNode, String descriptor) {
            return this.validate(currentNode, descriptor);
        }

        @Override
        public String validate(ModelNode currentNode, String descriptor) {
            if (currentNode.hasDefined(descriptor)) {
                List list;
                try {
                    list = currentNode.asList();
                }
                catch (Exception e) {
                    return "'" + descriptor + "' is not a list";
                }
                for (ModelNode entry : list) {
                    try {
                        entry.asString();
                    }
                    catch (Exception e) {
                        return "'" + descriptor + "' is not a string";
                    }
                }
            }
            return null;
        }
    }

    private static class AccessConstraintValidator
    implements ArbitraryDescriptorValidator,
    AttributeOrParameterArbitraryDescriptorValidator {
        static final AccessConstraintValidator INSTANCE = new AccessConstraintValidator();

        private AccessConstraintValidator() {
        }

        @Override
        public String validate(ModelNode currentNode, String descriptor) {
            return null;
        }

        @Override
        public String validate(ModelType currentType, ModelNode currentNode, String descriptor) {
            return null;
        }
    }

    private static class DeprecatedDescriptorValidator
    implements ArbitraryDescriptorValidator,
    AttributeOrParameterArbitraryDescriptorValidator {
        static final DeprecatedDescriptorValidator INSTANCE = new DeprecatedDescriptorValidator();

        private DeprecatedDescriptorValidator() {
        }

        @Override
        public String validate(ModelNode currentNode, String descriptor) {
            if (!currentNode.get(descriptor).hasDefined("since")) {
                return "model key 'since' is missing on deprecated definition for '" + descriptor + "'";
            }
            if (!currentNode.get(descriptor).hasDefined("reason")) {
                return "model key 'reason' is missing on deprecated definition for '" + descriptor + "'";
            }
            return null;
        }

        @Override
        public String validate(ModelType currentType, ModelNode currentNode, String descriptor) {
            return this.validate(currentNode, descriptor);
        }
    }

    private static class NullDescriptorValidator
    implements ArbitraryDescriptorValidator,
    AttributeOrParameterArbitraryDescriptorValidator {
        static final NullDescriptorValidator INSTANCE = new NullDescriptorValidator();

        private NullDescriptorValidator() {
        }

        @Override
        public String validate(ModelType currentType, ModelNode currentNode, String descriptor) {
            return null;
        }

        @Override
        public String validate(ModelNode currentNode, String descriptor) {
            return null;
        }
    }

    private static class StorageDescriptorValidator
    implements AttributeOrParameterArbitraryDescriptorValidator {
        static final StorageDescriptorValidator INSTANCE = new StorageDescriptorValidator();

        private StorageDescriptorValidator() {
        }

        @Override
        public String validate(ModelType currentType, ModelNode currentNode, String descriptor) {
            if (currentNode.hasDefined(descriptor)) {
                try {
                    AttributeAccess.Storage.valueOf((String)currentNode.get(descriptor).asString().toUpperCase(Locale.ENGLISH));
                }
                catch (Exception e) {
                    return "'" + descriptor + "' is not a storage type";
                }
            }
            return null;
        }
    }

    private static class AccessTypeDescriptorValidator
    implements AttributeOrParameterArbitraryDescriptorValidator {
        static final AccessTypeDescriptorValidator INSTANCE = new AccessTypeDescriptorValidator();

        private AccessTypeDescriptorValidator() {
        }

        @Override
        public String validate(ModelType currentType, ModelNode currentNode, String descriptor) {
            if (currentNode.hasDefined(descriptor)) {
                try {
                    AttributeAccess.AccessType.valueOf((String)currentNode.get(descriptor).asString().toUpperCase(Locale.ENGLISH).replace('-', '_'));
                }
                catch (Exception e) {
                    return "'" + descriptor + "=" + currentNode.get(descriptor) + "' is not an access type";
                }
            }
            return null;
        }
    }

    private static class BooleanDescriptorValidator
    implements ArbitraryDescriptorValidator,
    AttributeOrParameterArbitraryDescriptorValidator {
        static final BooleanDescriptorValidator INSTANCE = new BooleanDescriptorValidator();

        private BooleanDescriptorValidator() {
        }

        @Override
        public String validate(ModelType currentType, ModelNode currentNode, String descriptor) {
            if (currentNode.hasDefined(descriptor)) {
                try {
                    currentNode.get(descriptor).asBoolean();
                }
                catch (Exception e) {
                    return "'" + descriptor + "' is not a boolean";
                }
            }
            return null;
        }

        @Override
        public String validate(ModelNode currentNode, String descriptor) {
            return this.validate(null, currentNode, descriptor);
        }
    }

    private static class LengthDescriptorValidator
    implements AttributeOrParameterArbitraryDescriptorValidator {
        static final LengthDescriptorValidator INSTANCE = new LengthDescriptorValidator();

        private LengthDescriptorValidator() {
        }

        @Override
        public String validate(ModelType currentType, ModelNode currentNode, String descriptor) {
            if (currentNode.hasDefined(descriptor)) {
                if (currentType != ModelType.LIST && currentType != ModelType.STRING && currentType != ModelType.BYTES) {
                    return "Unnecessary '" + descriptor + "' for non-numeric type=" + currentType;
                }
                try {
                    currentNode.get(descriptor).asLong();
                }
                catch (Exception e) {
                    return "'" + descriptor + "' is not an int/long";
                }
            }
            return null;
        }
    }

    private static class NumericDescriptorValidator
    implements AttributeOrParameterArbitraryDescriptorValidator {
        static final NumericDescriptorValidator INSTANCE = new NumericDescriptorValidator();

        private NumericDescriptorValidator() {
        }

        @Override
        public String validate(ModelType currentType, ModelNode currentNode, String descriptor) {
            if (currentNode.hasDefined(descriptor)) {
                if (currentType != ModelType.BIG_DECIMAL && currentType != ModelType.BIG_INTEGER && currentType != ModelType.DOUBLE && currentType != ModelType.INT && currentType != ModelType.LONG) {
                    return "Unnecessary '" + descriptor + "' for non-numeric type=" + currentType;
                }
                if (!descriptor.equals("unit")) {
                    try {
                        if (currentType == ModelType.BIG_DECIMAL) {
                            currentNode.get(descriptor).asBigDecimal();
                        } else if (currentType == ModelType.BIG_INTEGER) {
                            currentNode.get(descriptor).asBigInteger();
                        } else if (currentType == ModelType.DOUBLE) {
                            currentNode.get(descriptor).asDouble();
                        } else if (currentType == ModelType.INT) {
                            currentNode.get(descriptor).asInt();
                        } else if (currentType == ModelType.LONG) {
                            currentNode.get(descriptor).asLong();
                        }
                    }
                    catch (Exception e) {
                        return "'" + descriptor + "' is not a " + currentType;
                    }
                }
            }
            return null;
        }
    }

    private static class SimpleIntDescriptorValidator
    implements ArbitraryDescriptorValidator {
        static final SimpleIntDescriptorValidator INSTANCE = new SimpleIntDescriptorValidator();

        private SimpleIntDescriptorValidator() {
        }

        @Override
        public String validate(ModelNode currentNode, String descriptor) {
            if (currentNode.hasDefined(descriptor)) {
                try {
                    currentNode.get(descriptor).asInt();
                }
                catch (Exception e) {
                    return "'" + descriptor + "' is not an int";
                }
            }
            return null;
        }
    }

    public static interface ArbitraryDescriptorValidator {
        public String validate(ModelNode var1, String var2);
    }

    public static interface AttributeOrParameterArbitraryDescriptorValidator {
        public String validate(ModelType var1, ModelNode var2, String var3);
    }
}

