/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.model.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class FailedOperationTransformationConfig {
    public static final FailedOperationTransformationConfig NO_FAILURES = new FailedOperationTransformationConfig();
    private PathAddressConfigRegistry registry = new PathAddressConfigRegistry();
    public static final PathAddressConfig DISCARDED_RESOURCE = new PathAddressConfig(){

        @Override
        public boolean expectFailedWriteAttributeOperation(ModelNode operation) {
            throw new IllegalStateException("Should not get called");
        }

        @Override
        public boolean expectFailed(ModelNode operation) {
            return false;
        }

        @Override
        public boolean expectDiscarded(ModelNode operation) {
            return true;
        }

        @Override
        public List<ModelNode> createWriteAttributeOperations(ModelNode operation) {
            return Collections.emptyList();
        }

        @Override
        public ModelNode correctWriteAttributeOperation(ModelNode operation) {
            throw new IllegalStateException("Should not get called");
        }

        @Override
        public ModelNode correctOperation(ModelNode operation) {
            throw new IllegalStateException("Should not get called");
        }

        @Override
        public boolean canCorrectMore(ModelNode operation) {
            throw new IllegalStateException("Should not get called");
        }
    };
    public static final PathAddressConfig REJECTED_RESOURCE = new PathAddressConfig(){

        @Override
        public boolean expectFailedWriteAttributeOperation(ModelNode operation) {
            throw new IllegalStateException("Should not get called");
        }

        @Override
        public boolean expectFailed(ModelNode operation) {
            return true;
        }

        @Override
        public boolean expectDiscarded(ModelNode operation) {
            return false;
        }

        @Override
        public List<ModelNode> createWriteAttributeOperations(ModelNode operation) {
            return Collections.emptyList();
        }

        @Override
        public ModelNode correctWriteAttributeOperation(ModelNode operation) {
            throw new IllegalStateException("Should not get called");
        }

        @Override
        public ModelNode correctOperation(ModelNode operation) {
            throw new IllegalStateException("Should not get called");
        }

        @Override
        public boolean canCorrectMore(ModelNode operation) {
            return false;
        }
    };

    public FailedOperationTransformationConfig addFailedAttribute(PathAddress pathAddress, PathAddressConfig config) {
        this.registry.addConfig(pathAddress.iterator(), config);
        return this;
    }

    boolean expectFailed(ModelNode operation) {
        PathAddressConfig cfg = this.registry.getConfig(operation);
        if (cfg == null) {
            return false;
        }
        return cfg.expectFailed(operation);
    }

    boolean expectDiscarded(ModelNode operation) {
        PathAddressConfig cfg = this.registry.getConfig(operation);
        if (cfg == null) {
            return false;
        }
        return cfg.expectDiscarded(operation);
    }

    boolean canCorrectMore(ModelNode operation) {
        PathAddressConfig cfg = this.registry.getConfig(operation);
        if (cfg == null) {
            return false;
        }
        return cfg.canCorrectMore(operation);
    }

    ModelNode correctOperation(ModelNode operation) {
        PathAddressConfig cfg = this.registry.getConfig(operation);
        if (cfg == null) {
            throw new IllegalStateException("No path address config found for " + PathAddress.pathAddress((ModelNode)operation.get("address")));
        }
        operation = cfg.correctOperation(operation);
        return operation;
    }

    List<ModelNode> createWriteAttributeOperations(ModelNode operation) {
        PathAddressConfig cfg = this.registry.getConfig(operation);
        if (cfg == null || !operation.get("operation").asString().equals("add")) {
            return Collections.emptyList();
        }
        return cfg.createWriteAttributeOperations(operation);
    }

    boolean expectFailedWriteAttributeOperation(ModelNode operation) {
        PathAddressConfig cfg = this.registry.getConfig(operation);
        if (cfg == null) {
            return false;
        }
        return cfg.expectFailedWriteAttributeOperation(operation);
    }

    ModelNode correctWriteAttributeOperation(ModelNode operation) {
        PathAddressConfig cfg = this.registry.getConfig(operation);
        if (cfg == null) {
            return operation;
        }
        return cfg.correctWriteAttributeOperation(operation);
    }

    public static class ChainedConfig
    extends AttributesPathAddressConfig<ChainedConfig> {
        private final List<AttributesPathAddressConfig<?>> list = new ArrayList();

        public ChainedConfig(List<AttributesPathAddressConfig<?>> configs, String ... attributes) {
            super(attributes);
            this.list.addAll(configs);
        }

        public ChainedConfig(List<AttributesPathAddressConfig<?>> configs, AttributeDefinition ... attributes) {
            super(ChainedConfig.convert(attributes));
            this.list.addAll(configs);
        }

        @Override
        public boolean expectFailed(ModelNode operation) {
            for (AttributesPathAddressConfig<?> link : this.list) {
                if (!link.expectFailed(operation)) continue;
                return true;
            }
            return false;
        }

        @Override
        public ModelNode correctOperation(ModelNode operation) {
            for (AttributesPathAddressConfig<?> link : this.list) {
                ModelNode op = link.correctOperation(operation);
                if (op.equals(operation)) continue;
                return op;
            }
            return operation;
        }

        @Override
        public ModelNode correctWriteAttributeOperation(ModelNode operation) {
            ModelNode op = operation.clone();
            for (AttributesPathAddressConfig<?> link : this.list) {
                op = link.correctWriteAttributeOperation(op);
            }
            return op;
        }

        @Override
        protected boolean isAttributeWritable(String attributeName) {
            return true;
        }

        @Override
        public boolean canCorrectMore(ModelNode operation) {
            for (AttributesPathAddressConfig<?> link : this.list) {
                if (!link.canCorrectMore(operation)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean expectFailedWriteAttributeOperation(ModelNode operation) {
            if (!this.noWriteFailureAttributes.contains(operation.get("name").asString())) {
                for (AttributesPathAddressConfig<?> link : this.list) {
                    if (!link.expectFailedWriteAttributeOperation(operation)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        protected boolean checkValue(String attrName, ModelNode attribute, boolean isWriteAttribute) {
            throw new IllegalStateException("Not all methods were overridden");
        }

        @Override
        protected ModelNode correctValue(ModelNode toResolve, boolean isWriteAttribute) {
            throw new IllegalStateException("Not all methods were overridden");
        }

        public static Builder createBuilder(final String ... attributes) {
            return new Builder(){
                ArrayList<AttributesPathAddressConfig<?>> list = new ArrayList();

                @Override
                public ChainedConfig build() {
                    return new ChainedConfig(this.list, attributes);
                }

                @Override
                public Builder addConfig(AttributesPathAddressConfig<?> cfg) {
                    this.list.add(cfg);
                    return this;
                }
            };
        }

        public static Builder createBuilder(AttributeDefinition ... attributes) {
            return ChainedConfig.createBuilder(ChainedConfig.convert(attributes));
        }

        public static interface Builder {
            public Builder addConfig(AttributesPathAddressConfig<?> var1);

            public ChainedConfig build();
        }
    }

    public static class NewAttributesConfig
    extends AttributesPathAddressConfig<NewAttributesConfig> {
        public NewAttributesConfig(String ... attributes) {
            super(attributes);
        }

        public NewAttributesConfig(AttributeDefinition ... attributes) {
            super(NewAttributesConfig.convert(attributes));
        }

        @Override
        protected boolean checkValue(String attrName, ModelNode attribute, boolean isWriteAttribute) {
            return attribute.isDefined();
        }

        @Override
        protected ModelNode correctValue(ModelNode attribute, boolean isWriteAttribute) {
            return new ModelNode();
        }

        @Override
        protected boolean isAttributeWritable(String attributeName) {
            return true;
        }
    }

    public static class RejectExpressionsConfig
    extends AttributesPathAddressConfig<RejectExpressionsConfig> {
        private final Pattern EXPRESSION_PATTERN = Pattern.compile(".*\\$\\{.*\\}.*");

        public RejectExpressionsConfig(String ... attributes) {
            super(attributes);
        }

        public RejectExpressionsConfig(AttributeDefinition ... attributes) {
            super(RejectExpressionsConfig.convert(attributes));
        }

        @Override
        protected ModelNode correctValue(ModelNode toResolve, boolean isWriteAttribute) {
            if (toResolve.getType() == ModelType.STRING) {
                toResolve = new ModelNode().setExpression(toResolve.asString());
            }
            return toResolve.resolve();
        }

        @Override
        protected boolean isAttributeWritable(String attributeName) {
            return true;
        }

        @Override
        protected boolean checkValue(String attrName, ModelNode attribute, boolean isWriteAttribute) {
            if (!attribute.isDefined()) {
                return false;
            }
            AttributesPathAddressConfig complexChildConfig = (AttributesPathAddressConfig)this.complexAttributes.get(attrName);
            switch (attribute.getType()) {
                case EXPRESSION: {
                    return true;
                }
                case STRING: {
                    return this.EXPRESSION_PATTERN.matcher(attribute.asString()).matches();
                }
                case LIST: {
                    for (ModelNode entry : attribute.asList()) {
                        if (!(complexChildConfig == null ? this.checkValue(attrName, entry, isWriteAttribute) : this.childHasExpressions(complexChildConfig, attribute.get(attrName), isWriteAttribute))) continue;
                        return true;
                    }
                    break;
                }
                case OBJECT: {
                    for (Property prop : attribute.asPropertyList()) {
                        if (!(complexChildConfig == null ? this.checkValue(attrName, prop.getValue(), isWriteAttribute) : this.childHasExpressions(complexChildConfig, attribute, isWriteAttribute))) continue;
                        return true;
                    }
                    break;
                }
                case PROPERTY: {
                    if (!(complexChildConfig == null ? this.checkValue(attrName, attribute.asProperty().getValue(), isWriteAttribute) : this.childHasExpressions(complexChildConfig, attribute.asProperty().getValue(), isWriteAttribute))) break;
                    return true;
                }
            }
            return false;
        }

        private boolean childHasExpressions(AttributesPathAddressConfig<?> complexChildConfig, ModelNode attribute, boolean isWriteAttribute) {
            for (String child : complexChildConfig.attributes) {
                if (!complexChildConfig.checkValue(child, attribute.get(child), isWriteAttribute)) continue;
                return true;
            }
            return false;
        }
    }

    public static abstract class AttributesPathAddressConfig<T extends AttributesPathAddressConfig<T>>
    implements PathAddressConfig {
        protected final Set<String> attributes;
        protected final Map<String, AttributesPathAddressConfig<?>> complexAttributes = new HashMap();
        protected final Set<String> noWriteFailureAttributes = new HashSet<String>();
        protected final Set<String> readOnlyAttributes = new HashSet<String>();

        protected AttributesPathAddressConfig(String ... attributes) {
            this.attributes = new HashSet<String>(Arrays.asList(attributes));
        }

        public AttributesPathAddressConfig<T> configureComplexAttribute(String attribute, T childConfig) {
            if (!this.attributes.contains(attribute)) {
                throw new IllegalStateException("Attempt to configure a complex attribute that was not set up as one of the original attributes");
            }
            this.complexAttributes.put(attribute, (AttributesPathAddressConfig<?>)childConfig);
            return this;
        }

        protected static String[] convert(AttributeDefinition ... defs) {
            String[] attrs = new String[defs.length];
            for (int i = 0; i < defs.length; ++i) {
                attrs[i] = defs[i].getName();
            }
            return attrs;
        }

        @Override
        public List<ModelNode> createWriteAttributeOperations(ModelNode operation) {
            ArrayList<ModelNode> list = new ArrayList<ModelNode>();
            for (String attr : this.attributes) {
                if (!operation.hasDefined(attr) || this.readOnlyAttributes.contains(attr) || !this.isAttributeWritable(attr)) continue;
                list.add(Util.getWriteAttributeOperation((PathAddress)PathAddress.pathAddress((ModelNode)operation.get("address")), (String)attr, (ModelNode)operation.get(attr)));
            }
            return list;
        }

        protected abstract boolean isAttributeWritable(String var1);

        public AttributesPathAddressConfig<T> setNotExpectedWriteFailure(String ... attributes) {
            for (String attr : attributes) {
                this.noWriteFailureAttributes.add(attr);
            }
            return this;
        }

        public AttributesPathAddressConfig<T> setNotExpectedWriteFailure(AttributeDefinition ... attributes) {
            for (AttributeDefinition attr : attributes) {
                this.noWriteFailureAttributes.add(attr.getName());
            }
            return this;
        }

        public AttributesPathAddressConfig<T> setReadOnly(String ... attributes) {
            for (String attr : attributes) {
                this.readOnlyAttributes.add(attr);
            }
            return this;
        }

        public AttributesPathAddressConfig<T> setReadOnly(AttributeDefinition ... attributes) {
            for (AttributeDefinition attr : attributes) {
                this.readOnlyAttributes.add(attr.getName());
            }
            return this;
        }

        @Override
        public boolean expectFailed(ModelNode operation) {
            ModelNode op = operation.clone();
            for (String attr : this.attributes) {
                if (!this.checkValue(attr, op.get(attr), false)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean canCorrectMore(ModelNode operation) {
            ModelNode op = operation.clone();
            for (String attr : this.attributes) {
                if (!this.checkValue(attr, op.get(attr), false)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean expectFailedWriteAttributeOperation(ModelNode operation) {
            String name = operation.get("name").asString();
            if (this.attributes.contains(name)) {
                return !this.noWriteFailureAttributes.contains(name) && this.checkValue(name, operation.clone().get("value"), true);
            }
            return false;
        }

        @Override
        public ModelNode correctOperation(ModelNode operation) {
            ModelNode op = operation.clone();
            for (String attr : this.attributes) {
                ModelNode value = op.get(attr);
                if (!value.isDefined() || !this.checkValue(attr, value, false)) continue;
                AttributesPathAddressConfig<?> complexChildConfig = this.complexAttributes.get(attr);
                if (complexChildConfig == null) {
                    ModelNode resolved = this.correctValue(op.get(attr), false);
                    op.get(attr).set(resolved);
                } else {
                    op.get(attr).set(complexChildConfig.correctOperation(operation.get(attr)));
                }
                return op;
            }
            return operation;
        }

        @Override
        public ModelNode correctWriteAttributeOperation(ModelNode operation) {
            ModelNode op = operation.clone();
            String name = operation.get("name").asString();
            if (this.attributes.contains(name) && this.checkValue(name, op.get("value"), true)) {
                op.get("value").set(this.correctValue(op.get("value"), true));
                return op;
            }
            return operation;
        }

        @Override
        public boolean expectDiscarded(ModelNode operation) {
            return false;
        }

        protected abstract boolean checkValue(String var1, ModelNode var2, boolean var3);

        protected abstract ModelNode correctValue(ModelNode var1, boolean var2);
    }

    public static interface PathAddressConfig {
        public boolean expectFailed(ModelNode var1);

        public boolean canCorrectMore(ModelNode var1);

        public ModelNode correctOperation(ModelNode var1);

        public List<ModelNode> createWriteAttributeOperations(ModelNode var1);

        public boolean expectFailedWriteAttributeOperation(ModelNode var1);

        public ModelNode correctWriteAttributeOperation(ModelNode var1);

        public boolean expectDiscarded(ModelNode var1);
    }

    private static class PathAddressConfigRegistry {
        private final Map<PathElement, PathAddressConfigRegistry> children = new HashMap<PathElement, PathAddressConfigRegistry>();
        private final Map<String, PathAddressConfigRegistry> wildcardChildren = new HashMap<String, PathAddressConfigRegistry>();
        private PathAddressConfig config;

        private PathAddressConfigRegistry() {
        }

        void addConfig(Iterator<PathElement> address, PathAddressConfig config) {
            if (address.hasNext()) {
                PathAddressConfigRegistry child = this.getOrCreateConfig(address.next());
                child.addConfig(address, config);
            } else {
                this.config = config;
            }
        }

        PathAddressConfigRegistry getOrCreateConfig(PathElement element) {
            if (element.isWildcard()) {
                PathAddressConfigRegistry reg = this.wildcardChildren.get(element.getKey());
                if (reg == null) {
                    reg = new PathAddressConfigRegistry();
                    this.wildcardChildren.put(element.getKey(), reg);
                }
                return reg;
            }
            PathAddressConfigRegistry reg = this.children.get(element);
            if (reg == null) {
                reg = new PathAddressConfigRegistry();
                this.children.put(element, reg);
            }
            return reg;
        }

        PathAddressConfig getConfig(ModelNode operation) {
            return this.getConfig(PathAddress.pathAddress((ModelNode)operation.get("address")).iterator());
        }

        PathAddressConfig getConfig(Iterator<PathElement> address) {
            if (address.hasNext()) {
                PathElement element = address.next();
                PathAddressConfigRegistry child = this.children.get(element);
                if (child == null) {
                    child = this.wildcardChildren.get(element.getKey());
                }
                if (child != null) {
                    return child.getConfig(address);
                }
                return null;
            }
            return this.config;
        }
    }
}

