/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.opentracing.smallrye;

import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="WFLYTRAC", length=4)
public interface TracingLogger
extends BasicLogger {
    public static final TracingLogger ROOT_LOGGER = (TracingLogger)Logger.getMessageLogger(TracingLogger.class, (String)TracingLogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1, value="Tracer initialized: %s")
    public void initializing(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=2, value="A Tracer is already registered at the GlobalTracer. Skipping resolution.")
    public void alreadyRegistered();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=3, value="Could not determine the service name and can't therefore use Jaeger Tracer. Using NoopTracer.")
    public void noServiceName();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=4, value="Registering %s as the OpenTracing Tracer")
    public void registeringTracer(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5, value="No tracer available to JAX-RS. Skipping MicroProfile OpenTracing configuration for JAX-RS")
    public void noTracerAvailable();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=6, value="Extra Tracer bean found: %s. Vetoing it, please use TracerResolver to specify a custom tracer to use.")
    public void extraTracerBean(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=7, value="Provided operation name does not match 'http-path' or 'class-method'. Using default 'class-method'.")
    public void wrongOperationNameProvider();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8, value="Producing tracer from ServletContext, using %s.")
    public void producingTracer(Object var1);
}

