/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.openapi.host;

import io.smallrye.openapi.spi.OASFactoryResolverImpl;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.spi.OASFactoryResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.SocketBinding;
import org.wildfly.common.function.Functions;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.UndertowListener;
import org.wildfly.microprofile.openapi.OpenAPIModelProvider;
import org.wildfly.microprofile.openapi.OpenAPIModelRegistry;
import org.wildfly.microprofile.openapi.host.CompositeOpenAPIModelProvider;
import org.wildfly.microprofile.openapi.host.HostOpenAPIModelConfiguration;
import org.wildfly.service.Installer;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class HostOpenAPIProviderServiceInstaller
implements ResourceServiceInstaller {
    private final HostOpenAPIModelConfiguration configuration;

    public HostOpenAPIProviderServiceInstaller(HostOpenAPIModelConfiguration configuration) {
        this.configuration = configuration;
    }

    public Consumer<OperationContext> install(OperationContext context) {
        if (!this.configuration.isEnabled()) {
            return Functions.discardingConsumer();
        }
        String serverName = this.configuration.getServerName();
        String hostName = this.configuration.getHostName();
        final boolean autoGenerateServers = this.configuration.isServerAutoGenerationEnabled();
        final String componentKeyFormat = this.configuration.getComponentKeyFormat();
        final UnaryOperator resolver = name -> this.configuration.getPropertyValue((String)name, String.class).orElse(null);
        ServiceDependency provider = ServiceDependency.on((BinaryServiceDescriptor)Host.SERVICE_DESCRIPTOR, (String)serverName, (String)hostName).map((Function)new Function<Host, CompositeOpenAPIModelProvider>(){

            @Override
            public CompositeOpenAPIModelProvider apply(Host host) {
                OpenAPI model = OASFactory.createOpenAPI().externalDocs(OASFactory.createExternalDocumentation().description((String)resolver.apply(HostOpenAPIModelConfiguration.EXTERNAL_DOCUMENTATION_DESCRIPTION)).url((String)resolver.apply(HostOpenAPIModelConfiguration.EXTERNAL_DOCUMENTATION_URL))).info(OASFactory.createInfo().contact(OASFactory.createContact().email((String)resolver.apply(HostOpenAPIModelConfiguration.INFO_CONTACT_EMAIL)).name((String)resolver.apply(HostOpenAPIModelConfiguration.INFO_CONTACT_NAME)).url((String)resolver.apply(HostOpenAPIModelConfiguration.INFO_CONTACT_URL))).description((String)resolver.apply(HostOpenAPIModelConfiguration.INFO_DESCRIPTION)).license(OASFactory.createLicense().identifier((String)resolver.apply(HostOpenAPIModelConfiguration.INFO_LICENSE_IDENTIFIER)).name((String)resolver.apply(HostOpenAPIModelConfiguration.INFO_LICENSE_NAME)).url((String)resolver.apply(HostOpenAPIModelConfiguration.INFO_LICENSE_URL))).summary((String)resolver.apply(HostOpenAPIModelConfiguration.INFO_SUMMARY)).termsOfService((String)resolver.apply(HostOpenAPIModelConfiguration.INFO_TERMS_OF_SERVICE)).title((String)resolver.apply(HostOpenAPIModelConfiguration.INFO_TITLE)).version((String)resolver.apply(HostOpenAPIModelConfiguration.INFO_VERSION))).jsonSchemaDialect((String)resolver.apply("jsonSchemaDialect")).openapi((String)resolver.apply("version"));
                if (autoGenerateServers) {
                    int aliases = host.getAllAliases().size();
                    List listeners = host.getServer().getListeners();
                    int size = 0;
                    for (UndertowListener listener : listeners) {
                        size += aliases + listener.getSocketBinding().getClientMappings().size();
                    }
                    ArrayList<Server> servers = new ArrayList<Server>(size);
                    for (UndertowListener listener : listeners) {
                        Server server;
                        SocketBinding binding = listener.getSocketBinding();
                        TreeSet<String> virtualHosts = new TreeSet<String>(host.getAllAliases());
                        virtualHosts.remove(host.getName());
                        InetAddress address = binding.getAddress();
                        if (!address.isAnyLocalAddress()) {
                            virtualHosts.add(address.getCanonicalHostName());
                        }
                        for (String virtualHost : virtualHosts) {
                            server = 1.createServer(listener.getProtocol(), virtualHost, binding.getPort());
                            if (server == null) continue;
                            servers.add(server);
                        }
                        for (ClientMapping mapping : binding.getClientMappings()) {
                            server = 1.createServer(listener.getProtocol(), mapping.getDestinationAddress(), mapping.getDestinationPort());
                            if (server == null) continue;
                            servers.add(server);
                        }
                    }
                    model.setServers(servers);
                }
                return new CompositeOpenAPIModelProvider(model, (name, key) -> String.format(componentKeyFormat, name, key));
            }

            private static Server createServer(String protocol, String host, int port) {
                try {
                    URL url = new URL(protocol, host, port, "");
                    if (port == url.getDefaultPort()) {
                        url = new URL(protocol, host, "");
                    }
                    return OASFactory.createServer().url(url.toString());
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
        });
        return ((ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((ServiceDependency)provider).startWhen(Installer.StartWhen.REQUIRED)).provides(ServiceNameFactory.resolveServiceName((BinaryServiceDescriptor)OpenAPIModelProvider.DEFAULT_SERVICE_DESCRIPTOR, (String)serverName, (String)hostName))).provides(ServiceNameFactory.resolveServiceName((BinaryServiceDescriptor)OpenAPIModelRegistry.SERVICE_DESCRIPTOR, (String)serverName, (String)hostName))).build()).install(context);
    }

    static {
        OASFactoryResolver.setInstance((OASFactoryResolver)new OASFactoryResolverImpl());
    }
}

