/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.openapi.host;

import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.wildfly.microprofile.openapi.OpenAPIModelConfiguration;

public class HostOpenAPIModelConfiguration
implements OpenAPIModelConfiguration {
    private static final String DELIMITER = ".";
    private static final String SMALLRYE_PREFIX = "mp.openapi.extensions.smallrye.";
    private static final String EXTERNAL_DOCUMENTATION = "externalDocs";
    private static final String DESCRIPTION = "description";
    private static final String URL = "url";
    public static final String EXTERNAL_DOCUMENTATION_DESCRIPTION = String.join((CharSequence)".", "externalDocs", "description");
    public static final String EXTERNAL_DOCUMENTATION_URL = String.join((CharSequence)".", "externalDocs", "url");
    public static final String INFO_CONTACT_EMAIL = "mp.openapi.extensions.smallrye.info.contact.email".substring("mp.openapi.extensions.smallrye.".length());
    public static final String INFO_CONTACT_NAME = "mp.openapi.extensions.smallrye.info.contact.name".substring("mp.openapi.extensions.smallrye.".length());
    public static final String INFO_CONTACT_URL = "mp.openapi.extensions.smallrye.info.contact.url".substring("mp.openapi.extensions.smallrye.".length());
    public static final String INFO_DESCRIPTION = "mp.openapi.extensions.smallrye.info.description".substring("mp.openapi.extensions.smallrye.".length());
    public static final String INFO_LICENSE_IDENTIFIER = "mp.openapi.extensions.smallrye.info.license.identifier".substring("mp.openapi.extensions.smallrye.".length());
    public static final String INFO_LICENSE_NAME = "mp.openapi.extensions.smallrye.info.license.name".substring("mp.openapi.extensions.smallrye.".length());
    public static final String INFO_LICENSE_URL = "mp.openapi.extensions.smallrye.info.license.url".substring("mp.openapi.extensions.smallrye.".length());
    public static final String INFO_SUMMARY = "mp.openapi.extensions.smallrye.info.summary".substring("mp.openapi.extensions.smallrye.".length());
    public static final String INFO_TERMS_OF_SERVICE = "mp.openapi.extensions.smallrye.info.termsOfService".substring("mp.openapi.extensions.smallrye.".length());
    public static final String INFO_TITLE = "mp.openapi.extensions.smallrye.info.title".substring("mp.openapi.extensions.smallrye.".length());
    public static final String INFO_VERSION = "mp.openapi.extensions.smallrye.info.version".substring("mp.openapi.extensions.smallrye.".length());
    public static final String JSON_SCHEMA_DIALECT = "jsonSchemaDialect";
    public static final String VERSION = "version";
    private static final String AUTO_GENERATE_SERVERS = "auto-generate-servers";
    private static final String COMPONENT_KEY_FORMAT = "component-key-format";
    private static final String DEFAULT_COMPONENT_KEY_FORMAT = "%1$s%2$s";
    private final Config config;
    private final String serverName;
    private final String hostName;

    public HostOpenAPIModelConfiguration(String serverName, String hostName) {
        this.serverName = serverName;
        this.hostName = hostName;
        this.config = ConfigProvider.getConfig((ClassLoader)HostOpenAPIModelConfiguration.class.getClassLoader());
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getPath() {
        return this.getPropertyValue("path", String.class).orElse(super.getPath());
    }

    public boolean isEnabled() {
        return this.getPropertyValue("enabled", Boolean.class).orElse(super.isEnabled());
    }

    public Config getMicroProfileConfig() {
        return this.config;
    }

    boolean isServerAutoGenerationEnabled() {
        return this.getPropertyValue(AUTO_GENERATE_SERVERS, Boolean.class).orElse(Boolean.FALSE);
    }

    String getComponentKeyFormat() {
        return this.getPropertyValue(COMPONENT_KEY_FORMAT, String.class).orElse(DEFAULT_COMPONENT_KEY_FORMAT);
    }

    <T> Optional<T> getPropertyValue(String propertyName, Class<T> propertyType) {
        Optional result = this.config.getOptionalValue(String.format("%sserver.%s.host.%s.%s", "mp.openapi.extensions.", this.serverName, this.hostName, propertyName), propertyType);
        if (result.isEmpty()) {
            result = this.config.getOptionalValue(String.format("%sserver.%s.%s", "mp.openapi.extensions.", this.serverName, propertyName), propertyType);
        }
        if (result.isEmpty()) {
            result = this.config.getOptionalValue("mp.openapi.extensions." + propertyName, propertyType);
        }
        return result;
    }
}

