/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.microprofile.openapi.host;

import io.smallrye.openapi.model.ReferenceType;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.StampedLock;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.Constructible;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.info.Contact;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.info.License;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.tags.Tag;
import org.wildfly.microprofile.openapi.OpenAPIModelProvider;
import org.wildfly.microprofile.openapi.OpenAPIModelRegistry;

public class CompositeOpenAPIModelProvider
implements OpenAPIModelProvider,
OpenAPIModelRegistry {
    private static final Function<Optional<ExternalDocumentation>, Optional<String>> EXTERNAL_DOCUMENTATION_DESCRIPTION = CompositeOpenAPIModelProvider.optional(ExternalDocumentation::getDescription);
    private static final Function<Optional<ExternalDocumentation>, Optional<String>> EXTERNAL_DOCUMENTATION_URL = CompositeOpenAPIModelProvider.optional(ExternalDocumentation::getUrl);
    private static final Function<Optional<Contact>, Optional<String>> CONTACT_EMAIL = CompositeOpenAPIModelProvider.optional(Contact::getEmail);
    private static final Function<Optional<Contact>, Optional<String>> CONTACT_NAME = CompositeOpenAPIModelProvider.optional(Contact::getName);
    private static final Function<Optional<Contact>, Optional<String>> CONTACT_URL = CompositeOpenAPIModelProvider.optional(Contact::getUrl);
    private static final Function<Optional<License>, Optional<String>> LICENSE_IDENTIFIER = CompositeOpenAPIModelProvider.optional(License::getIdentifier);
    private static final Function<Optional<License>, Optional<String>> LICENSE_NAME = CompositeOpenAPIModelProvider.optional(License::getName);
    private static final Function<Optional<License>, Optional<String>> LICENSE_URL = CompositeOpenAPIModelProvider.optional(License::getUrl);
    private static final Function<Optional<Info>, Optional<Contact>> INFO_CONTACT = CompositeOpenAPIModelProvider.optional(Info::getContact);
    private static final Function<Optional<Info>, Optional<String>> INFO_DESCRIPTION = CompositeOpenAPIModelProvider.optional(Info::getDescription);
    private static final Function<Optional<Info>, Optional<License>> INFO_LICENSE = CompositeOpenAPIModelProvider.optional(Info::getLicense);
    private static final Function<Optional<Info>, Optional<String>> INFO_SUMMARY = CompositeOpenAPIModelProvider.optional(Info::getSummary);
    private static final Function<Optional<Info>, Optional<String>> INFO_TERMS_OF_SERVICE = CompositeOpenAPIModelProvider.optional(Info::getTermsOfService);
    private static final Function<Optional<Info>, Optional<String>> INFO_TITLE = CompositeOpenAPIModelProvider.optional(Info::getTitle);
    private static final Function<Optional<Info>, Optional<String>> INFO_VERSION = CompositeOpenAPIModelProvider.optional(Info::getVersion);
    private static final Function<Optional<OpenAPI>, Optional<Components>> COMPONENTS = CompositeOpenAPIModelProvider.optional(OpenAPI::getComponents);
    private static final Function<Optional<OpenAPI>, Optional<ExternalDocumentation>> EXTERNAL_DOCUMENTATION = CompositeOpenAPIModelProvider.optional(OpenAPI::getExternalDocs);
    private static final Function<Optional<OpenAPI>, Optional<Info>> INFO = CompositeOpenAPIModelProvider.optional(OpenAPI::getInfo);
    private static final Function<Optional<OpenAPI>, Optional<Contact>> CONTACT = INFO.andThen(INFO_CONTACT);
    private static final Function<Optional<OpenAPI>, Optional<String>> JSON_SCHEMA_DIALECT = CompositeOpenAPIModelProvider.optional(OpenAPI::getJsonSchemaDialect);
    private static final Function<Optional<OpenAPI>, Optional<License>> LICENSE = INFO.andThen(INFO_LICENSE);
    private static final Function<Optional<OpenAPI>, Optional<Paths>> PATHS = CompositeOpenAPIModelProvider.optional(OpenAPI::getPaths);
    private static final Function<Optional<OpenAPI>, Optional<List<Server>>> SERVERS = CompositeOpenAPIModelProvider.optional(OpenAPI::getServers);
    private static final Function<Optional<OpenAPI>, Optional<String>> VERSION = CompositeOpenAPIModelProvider.optional(OpenAPI::getOpenapi);
    private static final Set<String> STANDARD_SCHEMA_PROPERTIES = new Supplier<Schema>(){

        @Override
        public Schema get() {
            Schema schema = OASFactory.createSchema();
            return ((Schema)((Schema)OASFactory.createSchema().additionalPropertiesSchema(schema).allOf(List.of(schema)).anyOf(List.of(schema)).comment("").constValue((Object)Duration.ZERO).contains(schema).contentEncoding("").contentMediaType("").contentSchema(schema).defaultValue((Object)"").dependentRequired(Map.of("", List.of(""))).dependentSchemas(Map.of("", schema)).deprecated(Boolean.FALSE).description("").discriminator(OASFactory.createDiscriminator()).elseSchema(schema).enumeration(List.of("")).examples(List.of("")).exclusiveMaximum(BigDecimal.ZERO).exclusiveMinimum(BigDecimal.ZERO).extensions(Map.of("", Duration.ZERO))).externalDocs(OASFactory.createExternalDocumentation()).format("").ifSchema(schema).items(schema).maxContains(Integer.valueOf(0)).maximum(BigDecimal.ZERO).maxItems(Integer.valueOf(0)).maxLength(Integer.valueOf(0)).maxProperties(Integer.valueOf(0)).minContains(Integer.valueOf(0)).minimum(BigDecimal.ZERO).minItems(Integer.valueOf(0)).minLength(Integer.valueOf(0)).minProperties(Integer.valueOf(0)).multipleOf(BigDecimal.ZERO).not(schema).oneOf(List.of(schema)).pattern("").patternProperties(Map.of("", schema)).prefixItems(List.of(schema)).properties(Map.of("", schema)).propertyNames(schema).readOnly(Boolean.TRUE).ref("")).required(List.of("")).schemaDialect("").thenSchema(schema).title("").type(List.of(Schema.SchemaType.NULL)).unevaluatedItems(schema).unevaluatedProperties(schema).uniqueItems(Boolean.FALSE).writeOnly(Boolean.FALSE).xml(OASFactory.createXML());
        }
    }.get().getAll().keySet();
    private final Optional<OpenAPI> defaultModel;
    private final BinaryOperator<String> resolver;
    private final StampedLock lock = new StampedLock();
    private final Map<String, Optional<OpenAPI>> models = new TreeMap<String, Optional<OpenAPI>>();
    private final AtomicReference<OpenAPI> provider = new AtomicReference();

    private static <T, R> Function<Optional<T>, Optional<R>> optional(final Function<T, R> function) {
        return new Function<Optional<T>, Optional<R>>(){

            @Override
            public Optional<R> apply(Optional<T> value) {
                return value.map(function);
            }
        };
    }

    CompositeOpenAPIModelProvider(OpenAPI defaultModel, BinaryOperator<String> resolver) {
        this.defaultModel = Optional.of(defaultModel);
        this.resolver = resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenAPIModelRegistry.Registration register(String key, OpenAPI model) {
        Optional<OpenAPI> optionalModel = Optional.of(model);
        long stamp = this.lock.writeLock();
        try {
            if (this.models.put(key, optionalModel) != optionalModel) {
                this.provider.setPlain(null);
            }
            OpenAPIModelRegistry.Registration registration = () -> this.remove(key);
            return registration;
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(String key) {
        long stamp = this.lock.writeLock();
        try {
            if (this.models.remove(key) != null) {
                this.provider.setPlain(null);
            }
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    public Optional<OpenAPI> getDefaultModel() {
        return this.defaultModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Optional<OpenAPI>> getModels() {
        long stamp = this.lock.readLock();
        try {
            Map<String, Optional<OpenAPI>> map = Map.copyOf(this.models);
            return map;
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenAPI getModel() {
        OpenAPI model = null;
        boolean update = false;
        long stamp = this.lock.tryOptimisticRead();
        try {
            if (StampedLock.isOptimisticReadStamp(stamp)) {
                model = this.provider.getPlain();
                boolean bl = update = model == null;
            }
            if (!this.lock.validate(stamp)) {
                stamp = this.lock.readLock();
                model = this.provider.getPlain();
                boolean bl = update = model == null;
            }
            if (update) {
                long conversionStamp = this.lock.tryConvertToWriteLock(stamp);
                if (StampedLock.isWriteLockStamp(conversionStamp)) {
                    stamp = conversionStamp;
                } else {
                    if (StampedLock.isReadLockStamp(stamp)) {
                        this.lock.unlockRead(stamp);
                    }
                    stamp = this.lock.writeLock();
                    model = this.provider.getPlain();
                    boolean bl = update = model == null;
                }
                if (update) {
                    model = new OpenAPIModelFactory(this.models).getModel();
                    this.provider.setPlain(model);
                }
            }
            OpenAPI openAPI = model;
            return openAPI;
        }
        finally {
            if (StampedLock.isLockStamp(stamp)) {
                this.lock.unlock(stamp);
            }
        }
    }

    private static <T> BiConsumer<String, T> resolve(final BiConsumer<String, T> accumulator, final UnaryOperator<String> resolver) {
        return new BiConsumer<String, T>(){

            @Override
            public void accept(String name, T value) {
                accumulator.accept((String)resolver.apply(name), value);
            }
        };
    }

    private static void addCallbacks(Map<String, Callback> callbacks, BiConsumer<String, Callback> accumulator, UnaryOperator<String> resolver) {
        if (callbacks != null) {
            for (Map.Entry<String, Callback> entry : callbacks.entrySet()) {
                accumulator.accept(entry.getKey(), CompositeOpenAPIModelProvider.resolve(entry.getValue(), resolver));
            }
        }
    }

    private static void addExamples(Map<String, Example> examples, BiConsumer<String, Example> accumulator, UnaryOperator<String> resolver) {
        if (examples != null) {
            for (Map.Entry<String, Example> entry : examples.entrySet()) {
                accumulator.accept(entry.getKey(), CompositeOpenAPIModelProvider.resolve(entry.getValue(), resolver));
            }
        }
    }

    private static void addHeaders(Map<String, Header> headers, BiConsumer<String, Header> accumulator, UnaryOperator<String> resolver) {
        if (headers != null) {
            for (Map.Entry<String, Header> entry : headers.entrySet()) {
                accumulator.accept(entry.getKey(), CompositeOpenAPIModelProvider.resolve(entry.getValue(), resolver));
            }
        }
    }

    private static void addLinks(Map<String, Link> links, BiConsumer<String, Link> accumulator, UnaryOperator<String> resolver) {
        if (links != null) {
            for (Map.Entry<String, Link> entry : links.entrySet()) {
                accumulator.accept(entry.getKey(), CompositeOpenAPIModelProvider.resolve(entry.getValue(), resolver));
            }
        }
    }

    private static void addMediaTypes(Map<String, MediaType> mediaTypes, BiConsumer<String, MediaType> accumulator, UnaryOperator<String> resolver) {
        if (mediaTypes != null) {
            for (Map.Entry<String, MediaType> entry : mediaTypes.entrySet()) {
                accumulator.accept(entry.getKey(), CompositeOpenAPIModelProvider.resolve(entry.getValue(), resolver));
            }
        }
    }

    private static void addOperations(Map<PathItem.HttpMethod, Operation> operations, BiConsumer<PathItem.HttpMethod, Operation> accumulator, UnaryOperator<String> resolver) {
        if (operations != null) {
            for (Map.Entry<PathItem.HttpMethod, Operation> entry : operations.entrySet()) {
                accumulator.accept(entry.getKey(), CompositeOpenAPIModelProvider.resolve(entry.getValue(), resolver));
            }
        }
    }

    private static void addParameters(Map<String, Parameter> parameters, BiConsumer<String, Parameter> accumulator, UnaryOperator<String> resolver) {
        if (parameters != null) {
            for (Map.Entry<String, Parameter> entry : parameters.entrySet()) {
                accumulator.accept(entry.getKey(), CompositeOpenAPIModelProvider.resolve(entry.getValue(), resolver));
            }
        }
    }

    private static void addParameters(List<Parameter> parameters, Consumer<Parameter> accumulator, UnaryOperator<String> resolver) {
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                accumulator.accept(CompositeOpenAPIModelProvider.resolve(parameter, resolver));
            }
        }
    }

    private static void addPathItems(Map<String, PathItem> pathItems, BiConsumer<String, PathItem> accumulator, UnaryOperator<String> resolver) {
        if (pathItems != null) {
            for (Map.Entry<String, PathItem> entry : pathItems.entrySet()) {
                accumulator.accept(entry.getKey(), CompositeOpenAPIModelProvider.resolve(entry.getValue(), resolver));
            }
        }
    }

    private static void addRequestBodies(Map<String, RequestBody> requestBodies, BiConsumer<String, RequestBody> accumulator, UnaryOperator<String> resolver) {
        if (requestBodies != null) {
            for (Map.Entry<String, RequestBody> entry : requestBodies.entrySet()) {
                accumulator.accept(entry.getKey(), CompositeOpenAPIModelProvider.resolve(entry.getValue(), resolver));
            }
        }
    }

    private static void addResponses(Map<String, APIResponse> responses, BiConsumer<String, APIResponse> accumulator, UnaryOperator<String> resolver) {
        if (responses != null) {
            for (Map.Entry<String, APIResponse> entry : responses.entrySet()) {
                accumulator.accept(entry.getKey(), CompositeOpenAPIModelProvider.resolve(entry.getValue(), resolver));
            }
        }
    }

    private static void addSchemas(List<Schema> schemas, Consumer<Schema> accumulator, UnaryOperator<String> resolver) {
        if (schemas != null) {
            for (Schema schema : schemas) {
                accumulator.accept(CompositeOpenAPIModelProvider.resolve(schema, resolver));
            }
        }
    }

    private static void addSchemas(Map<String, Schema> schemas, BiConsumer<String, Schema> accumulator, UnaryOperator<String> resolver) {
        if (schemas != null) {
            for (Map.Entry<String, Schema> entry : schemas.entrySet()) {
                accumulator.accept(entry.getKey(), CompositeOpenAPIModelProvider.resolve(entry.getValue(), resolver));
            }
        }
    }

    private static void addSecurityRequirements(List<SecurityRequirement> requirements, Consumer<SecurityRequirement> accumulator, UnaryOperator<String> resolver) {
        if (requirements != null) {
            for (SecurityRequirement requirement : requirements) {
                accumulator.accept(CompositeOpenAPIModelProvider.resolve(requirement, resolver));
            }
        }
    }

    private static void addSecuritySchemes(Map<String, SecurityScheme> schemes, BiConsumer<String, SecurityScheme> accumulator, UnaryOperator<String> resolver) {
        if (schemes != null) {
            for (Map.Entry<String, SecurityScheme> entry : schemes.entrySet()) {
                accumulator.accept(entry.getKey(), CompositeOpenAPIModelProvider.resolve(entry.getValue(), resolver));
            }
        }
    }

    private static void addTags(List<Tag> tags, Consumer<Tag> accumulator, UnaryOperator<String> resolver) {
        if (tags != null) {
            for (Tag tag : tags) {
                accumulator.accept(CompositeOpenAPIModelProvider.resolve(tag, resolver));
            }
        }
    }

    private static void addTagRefs(List<String> tags, Consumer<String> accumulator, UnaryOperator<String> resolver) {
        if (tags != null) {
            for (String tag : tags) {
                accumulator.accept((String)resolver.apply(tag));
            }
        }
    }

    private static Callback resolve(Callback callback, UnaryOperator<String> resolver) {
        Callback result = CompositeOpenAPIModelProvider.resolveReference(ReferenceType.CALLBACK, Callback.class, callback, resolver);
        CompositeOpenAPIModelProvider.addPathItems(callback.getPathItems(), (arg_0, arg_1) -> ((Callback)result).addPathItem(arg_0, arg_1), resolver);
        return result;
    }

    private static Content resolve(Content content, UnaryOperator<String> resolver) {
        Content result;
        Object object = result = content != null ? OASFactory.createContent() : null;
        if (result != null) {
            CompositeOpenAPIModelProvider.addMediaTypes(content.getMediaTypes(), (arg_0, arg_1) -> ((Content)result).addMediaType(arg_0, arg_1), resolver);
        }
        return result;
    }

    private static Example resolve(Example example, UnaryOperator<String> resolver) {
        return CompositeOpenAPIModelProvider.resolveReference(ReferenceType.EXAMPLE, Example.class, example, resolver).description(example.getDescription()).externalValue(CompositeOpenAPIModelProvider.resolve(ReferenceType.EXAMPLE, example.getExternalValue(), resolver)).summary(example.getSummary()).value(example.getValue());
    }

    private static Header resolve(Header header, UnaryOperator<String> resolver) {
        Header result = CompositeOpenAPIModelProvider.resolveReference(ReferenceType.HEADER, Header.class, header, resolver).allowEmptyValue(header.getAllowEmptyValue()).content(CompositeOpenAPIModelProvider.resolve(header.getContent(), resolver)).deprecated(header.getDeprecated()).description(header.getDescription()).example(header.getExample()).explode(header.getExplode()).required(header.getRequired()).schema(CompositeOpenAPIModelProvider.resolve(header.getSchema(), resolver)).style(header.getStyle());
        CompositeOpenAPIModelProvider.addExamples(header.getExamples(), (arg_0, arg_1) -> ((Header)result).addExample(arg_0, arg_1), resolver);
        return result;
    }

    private static Link resolve(Link link, UnaryOperator<String> resolver) {
        return CompositeOpenAPIModelProvider.resolveReference(ReferenceType.LINK, Link.class, link, resolver).description(link.getDescription()).operationId(link.getOperationId()).operationRef(CompositeOpenAPIModelProvider.resolve(ReferenceType.PATH_ITEM, link.getOperationRef(), resolver)).requestBody(link.getRequestBody()).parameters(link.getParameters()).server(link.getServer());
    }

    private static MediaType resolve(MediaType mediaType, UnaryOperator<String> resolver) {
        MediaType result;
        MediaType mediaType2 = result = mediaType != null ? ((MediaType)CompositeOpenAPIModelProvider.resolveExtensible(MediaType.class, mediaType, resolver).encoding(mediaType.getEncoding()).example(mediaType.getExample()).extensions(mediaType.getExtensions())).schema(CompositeOpenAPIModelProvider.resolve(mediaType.getSchema(), resolver)) : null;
        if (result != null) {
            CompositeOpenAPIModelProvider.addExamples(mediaType.getExamples(), (arg_0, arg_1) -> result.addExample(arg_0, arg_1), resolver);
        }
        return result;
    }

    private static Operation resolve(Operation operation, UnaryOperator<String> resolver) {
        Operation result = CompositeOpenAPIModelProvider.resolveExtensible(Operation.class, operation, resolver).deprecated(operation.getDeprecated()).description(operation.getDescription()).externalDocs(operation.getExternalDocs()).operationId(operation.getOperationId()).requestBody(CompositeOpenAPIModelProvider.resolve(operation.getRequestBody(), resolver)).responses(CompositeOpenAPIModelProvider.resolve(operation.getResponses(), resolver)).servers(operation.getServers()).summary(operation.getSummary());
        CompositeOpenAPIModelProvider.addCallbacks(operation.getCallbacks(), (arg_0, arg_1) -> ((Operation)result).addCallback(arg_0, arg_1), resolver);
        CompositeOpenAPIModelProvider.addParameters(operation.getParameters(), arg_0 -> ((Operation)result).addParameter(arg_0), resolver);
        CompositeOpenAPIModelProvider.addSecurityRequirements(operation.getSecurity(), arg_0 -> ((Operation)result).addSecurityRequirement(arg_0), resolver);
        CompositeOpenAPIModelProvider.addTagRefs(operation.getTags(), arg_0 -> ((Operation)result).addTag(arg_0), resolver);
        return result;
    }

    private static Parameter resolve(Parameter parameter, UnaryOperator<String> resolver) {
        Parameter result;
        Parameter parameter2 = result = parameter != null ? CompositeOpenAPIModelProvider.resolveReference(ReferenceType.PARAMETER, Parameter.class, parameter, resolver).allowEmptyValue(parameter.getAllowEmptyValue()).allowReserved(parameter.getAllowReserved()).content(CompositeOpenAPIModelProvider.resolve(parameter.getContent(), resolver)).deprecated(parameter.getDeprecated()).description(parameter.getDescription()).example(parameter.getExample()).explode(parameter.getExplode()).in(parameter.getIn()).name(parameter.getName()).required(parameter.getRequired()).schema(CompositeOpenAPIModelProvider.resolve(parameter.getSchema(), resolver)).style(parameter.getStyle()) : null;
        if (result != null) {
            CompositeOpenAPIModelProvider.addExamples(parameter.getExamples(), (arg_0, arg_1) -> result.addExample(arg_0, arg_1), resolver);
        }
        return result;
    }

    private static PathItem resolve(PathItem pathItem, UnaryOperator<String> resolver) {
        PathItem result = CompositeOpenAPIModelProvider.resolveReference(ReferenceType.PATH_ITEM, PathItem.class, pathItem, resolver).description(pathItem.getDescription()).servers(pathItem.getServers()).summary(pathItem.getSummary());
        CompositeOpenAPIModelProvider.addOperations(pathItem.getOperations(), (arg_0, arg_1) -> ((PathItem)result).setOperation(arg_0, arg_1), resolver);
        CompositeOpenAPIModelProvider.addParameters(pathItem.getParameters(), arg_0 -> ((PathItem)result).addParameter(arg_0), resolver);
        return result;
    }

    private static RequestBody resolve(RequestBody requestBody, UnaryOperator<String> resolver) {
        return requestBody != null ? CompositeOpenAPIModelProvider.resolveReference(ReferenceType.REQUEST_BODY, RequestBody.class, requestBody, resolver).content(CompositeOpenAPIModelProvider.resolve(requestBody.getContent(), resolver)).description(requestBody.getDescription()).required(requestBody.getRequired()) : null;
    }

    private static APIResponse resolve(APIResponse response, UnaryOperator<String> resolver) {
        APIResponse result;
        APIResponse aPIResponse = result = response != null ? CompositeOpenAPIModelProvider.resolveReference(ReferenceType.RESPONSE, APIResponse.class, response, resolver).content(CompositeOpenAPIModelProvider.resolve(response.getContent(), resolver)).description(response.getDescription()) : null;
        if (result != null) {
            CompositeOpenAPIModelProvider.addHeaders(response.getHeaders(), (arg_0, arg_1) -> result.addHeader(arg_0, arg_1), resolver);
            CompositeOpenAPIModelProvider.addLinks(response.getLinks(), (arg_0, arg_1) -> ((APIResponse)result).addLink(arg_0, arg_1), resolver);
        }
        return result;
    }

    private static APIResponses resolve(APIResponses responses, UnaryOperator<String> resolver) {
        APIResponses result;
        APIResponses aPIResponses = result = responses != null ? CompositeOpenAPIModelProvider.resolveExtensible(APIResponses.class, responses, resolver).defaultValue(CompositeOpenAPIModelProvider.resolve(responses.getDefaultValue(), resolver)) : null;
        if (result != null) {
            CompositeOpenAPIModelProvider.addResponses(responses.getAPIResponses(), (arg_0, arg_1) -> ((APIResponses)result).addAPIResponse(arg_0, arg_1), resolver);
        }
        return result;
    }

    private static Schema resolve(Schema schema, UnaryOperator<String> resolver) {
        Schema result;
        Schema schema2 = result = schema != null ? CompositeOpenAPIModelProvider.resolveReference(ReferenceType.SCHEMA, Schema.class, schema, resolver).booleanSchema(schema.getBooleanSchema()) : null;
        if (result != null) {
            if (result.getBooleanSchema() == null) {
                result.additionalPropertiesSchema(CompositeOpenAPIModelProvider.resolve(schema.getAdditionalPropertiesSchema(), resolver)).comment(schema.getComment()).constValue(schema.getConstValue()).contains(CompositeOpenAPIModelProvider.resolve(schema.getContains(), resolver)).contentEncoding(schema.getContentEncoding()).contentMediaType(schema.getContentMediaType()).contentSchema(CompositeOpenAPIModelProvider.resolve(schema.getContentSchema(), resolver)).defaultValue(schema.getDefaultValue()).dependentRequired(schema.getDependentRequired()).deprecated(schema.getDeprecated()).description(schema.getDescription()).discriminator(schema.getDiscriminator()).elseSchema(CompositeOpenAPIModelProvider.resolve(schema.getElseSchema(), resolver)).enumeration(schema.getEnumeration()).examples(schema.getExamples()).exclusiveMaximum(schema.getExclusiveMaximum()).exclusiveMinimum(schema.getExclusiveMinimum()).externalDocs(schema.getExternalDocs()).format(schema.getFormat()).ifSchema(CompositeOpenAPIModelProvider.resolve(schema.getIfSchema(), resolver)).items(CompositeOpenAPIModelProvider.resolve(schema.getItems(), resolver)).maxContains(schema.getMaxContains()).maximum(schema.getMaximum()).maxItems(schema.getMaxItems()).maxLength(schema.getMaxLength()).maxProperties(schema.getMaxProperties()).minContains(schema.getMinContains()).minimum(schema.getMinimum()).minItems(schema.getMinItems()).minLength(schema.getMinLength()).minProperties(schema.getMinProperties()).multipleOf(schema.getMultipleOf()).not(CompositeOpenAPIModelProvider.resolve(schema.getNot(), resolver)).pattern(schema.getPattern()).propertyNames(CompositeOpenAPIModelProvider.resolve(schema.getPropertyNames(), resolver)).readOnly(schema.getReadOnly()).required(schema.getRequired()).schemaDialect(schema.getSchemaDialect()).thenSchema(CompositeOpenAPIModelProvider.resolve(schema.getThenSchema(), resolver)).title(schema.getTitle()).type(schema.getType()).unevaluatedItems(CompositeOpenAPIModelProvider.resolve(schema.getUnevaluatedItems(), resolver)).unevaluatedProperties(CompositeOpenAPIModelProvider.resolve(schema.getUnevaluatedProperties(), resolver)).uniqueItems(schema.getUniqueItems()).writeOnly(schema.getWriteOnly()).xml(schema.getXml());
                for (Map.Entry entry : schema.getAll().entrySet()) {
                    if (STANDARD_SCHEMA_PROPERTIES.contains(entry.getKey())) continue;
                    result.set((String)entry.getKey(), entry.getValue());
                }
            }
            CompositeOpenAPIModelProvider.addSchemas(schema.getAllOf(), arg_0 -> ((Schema)result).addAllOf(arg_0), resolver);
            CompositeOpenAPIModelProvider.addSchemas(schema.getAnyOf(), arg_0 -> ((Schema)result).addAnyOf(arg_0), resolver);
            CompositeOpenAPIModelProvider.addSchemas(schema.getDependentSchemas(), (arg_0, arg_1) -> ((Schema)result).addDependentSchema(arg_0, arg_1), resolver);
            CompositeOpenAPIModelProvider.addSchemas(schema.getOneOf(), arg_0 -> ((Schema)result).addOneOf(arg_0), resolver);
            CompositeOpenAPIModelProvider.addSchemas(schema.getPatternProperties(), (arg_0, arg_1) -> ((Schema)result).addPatternProperty(arg_0, arg_1), resolver);
            CompositeOpenAPIModelProvider.addSchemas(schema.getPrefixItems(), arg_0 -> ((Schema)result).addPrefixItem(arg_0), resolver);
            CompositeOpenAPIModelProvider.addSchemas(schema.getProperties(), (arg_0, arg_1) -> ((Schema)result).addProperty(arg_0, arg_1), resolver);
        }
        return result;
    }

    private static SecurityRequirement resolve(SecurityRequirement requirement, UnaryOperator<String> resolver) {
        SecurityRequirement result = OASFactory.createSecurityRequirement();
        for (Map.Entry entry : Optional.ofNullable(requirement.getSchemes()).orElse(Map.of()).entrySet()) {
            result.addScheme((String)resolver.apply((String)entry.getKey()), (List)entry.getValue());
        }
        return result;
    }

    private static SecurityScheme resolve(SecurityScheme scheme, UnaryOperator<String> resolver) {
        return CompositeOpenAPIModelProvider.resolveReference(ReferenceType.SECURITY_SCHEME, SecurityScheme.class, scheme, resolver).bearerFormat(scheme.getBearerFormat()).description(scheme.getDescription()).flows(scheme.getFlows()).in(scheme.getIn()).name(scheme.getName()).openIdConnectUrl(scheme.getOpenIdConnectUrl()).scheme(scheme.getScheme()).type(scheme.getType());
    }

    private static Tag resolve(Tag tag, UnaryOperator<String> resolver) {
        return CompositeOpenAPIModelProvider.resolveExtensible(Tag.class, tag, resolver).description(tag.getDescription()).externalDocs(tag.getExternalDocs()).name((String)resolver.apply(tag.getName()));
    }

    private static <T extends Reference<T> & Extensible<T>> T resolveReference(ReferenceType type, Class<T> componentClass, T component, UnaryOperator<String> resolver) {
        return (T)(component != null ? ((Reference)CompositeOpenAPIModelProvider.resolveExtensible(componentClass, component, resolver)).ref(CompositeOpenAPIModelProvider.resolve(type, component.getRef(), resolver)) : null);
    }

    private static <T extends Extensible<T> & Constructible> T resolveExtensible(Class<T> componentClass, T component, UnaryOperator<String> resolver) {
        return (T)(component != null ? ((Extensible)OASFactory.createObject(componentClass)).extensions(component.getExtensions()) : null);
    }

    private static <T extends Reference<T> & Constructible> String resolve(ReferenceType type, String value, UnaryOperator<String> resolver) {
        return value != null && value.startsWith(type.referencePrefix()) ? type.referenceOf((String)resolver.apply(value.substring(type.referencePrefix().length() + 1))) : value;
    }

    private class OpenAPIModelFactory
    implements OpenAPIModelProvider {
        private final Map<String, Optional<OpenAPI>> models;

        OpenAPIModelFactory(Map<String, Optional<OpenAPI>> models) {
            this.models = models;
        }

        public OpenAPI getModel() {
            OpenAPI result = ((OpenAPI)OASFactory.createOpenAPI().components((Components)OASFactory.createComponents().extensions(this.extensions(COMPONENTS))).extensions(this.extensions(UnaryOperator.identity()))).externalDocs(((ExternalDocumentation)OASFactory.createExternalDocumentation().description(this.singleton(EXTERNAL_DOCUMENTATION.andThen(EXTERNAL_DOCUMENTATION_DESCRIPTION))).extensions(this.extensions(EXTERNAL_DOCUMENTATION))).url(this.singleton(EXTERNAL_DOCUMENTATION.andThen(EXTERNAL_DOCUMENTATION_URL)))).info(((Info)OASFactory.createInfo().contact(((Contact)OASFactory.createContact().email(this.singleton(CONTACT.andThen(CONTACT_EMAIL))).extensions(this.extensions(CONTACT))).name(this.singleton(CONTACT.andThen(CONTACT_NAME))).url(this.singleton(CONTACT.andThen(CONTACT_URL)))).description(this.singleton(INFO.andThen(INFO_DESCRIPTION))).extensions(this.extensions(INFO))).license(((License)OASFactory.createLicense().extensions(this.extensions(LICENSE))).identifier(this.singleton(LICENSE.andThen(LICENSE_IDENTIFIER))).name(this.singleton(LICENSE.andThen(LICENSE_NAME))).url(this.singleton(LICENSE.andThen(LICENSE_URL)))).summary(this.singleton(INFO.andThen(INFO_SUMMARY))).termsOfService(this.singleton(INFO.andThen(INFO_TERMS_OF_SERVICE))).title(this.singleton(INFO.andThen(INFO_TITLE))).version(this.singleton(INFO.andThen(INFO_VERSION)))).jsonSchemaDialect(this.singleton(JSON_SCHEMA_DIALECT)).openapi(this.singleton(VERSION)).paths((Paths)OASFactory.createPaths().extensions(this.extensions(PATHS))).servers(this.list(SERVERS));
            for (Map.Entry<String, Optional<OpenAPI>> entry : this.models.entrySet()) {
                Paths paths;
                String key = entry.getKey();
                if (!entry.getValue().isPresent()) continue;
                OpenAPI model = entry.getValue().get();
                UnaryOperator resolver = this.models.size() > 1 ? name -> (String)CompositeOpenAPIModelProvider.this.resolver.apply(key, name) : UnaryOperator.identity();
                Components components = model.getComponents();
                if (components != null) {
                    CompositeOpenAPIModelProvider.addCallbacks(components.getCallbacks(), CompositeOpenAPIModelProvider.resolve((arg_0, arg_1) -> ((Components)result.getComponents()).addCallback(arg_0, arg_1), (UnaryOperator<String>)resolver), resolver);
                    CompositeOpenAPIModelProvider.addExamples(components.getExamples(), CompositeOpenAPIModelProvider.resolve((arg_0, arg_1) -> ((Components)result.getComponents()).addExample(arg_0, arg_1), (UnaryOperator<String>)resolver), resolver);
                    CompositeOpenAPIModelProvider.addHeaders(components.getHeaders(), CompositeOpenAPIModelProvider.resolve((arg_0, arg_1) -> ((Components)result.getComponents()).addHeader(arg_0, arg_1), (UnaryOperator<String>)resolver), resolver);
                    CompositeOpenAPIModelProvider.addLinks(components.getLinks(), CompositeOpenAPIModelProvider.resolve((arg_0, arg_1) -> ((Components)result.getComponents()).addLink(arg_0, arg_1), (UnaryOperator<String>)resolver), resolver);
                    CompositeOpenAPIModelProvider.addParameters(components.getParameters(), CompositeOpenAPIModelProvider.resolve((arg_0, arg_1) -> ((Components)result.getComponents()).addParameter(arg_0, arg_1), (UnaryOperator<String>)resolver), (UnaryOperator<String>)resolver);
                    CompositeOpenAPIModelProvider.addPathItems(components.getPathItems(), CompositeOpenAPIModelProvider.resolve((arg_0, arg_1) -> ((Components)result.getComponents()).addPathItem(arg_0, arg_1), (UnaryOperator<String>)resolver), resolver);
                    CompositeOpenAPIModelProvider.addRequestBodies(components.getRequestBodies(), CompositeOpenAPIModelProvider.resolve((arg_0, arg_1) -> ((Components)result.getComponents()).addRequestBody(arg_0, arg_1), (UnaryOperator<String>)resolver), resolver);
                    CompositeOpenAPIModelProvider.addResponses(components.getResponses(), CompositeOpenAPIModelProvider.resolve((arg_0, arg_1) -> ((Components)result.getComponents()).addResponse(arg_0, arg_1), (UnaryOperator<String>)resolver), resolver);
                    CompositeOpenAPIModelProvider.addSchemas(components.getSchemas(), CompositeOpenAPIModelProvider.resolve((arg_0, arg_1) -> ((Components)result.getComponents()).addSchema(arg_0, arg_1), (UnaryOperator<String>)resolver), (UnaryOperator<String>)resolver);
                    CompositeOpenAPIModelProvider.addSecuritySchemes(components.getSecuritySchemes(), CompositeOpenAPIModelProvider.resolve((arg_0, arg_1) -> ((Components)result.getComponents()).addSecurityScheme(arg_0, arg_1), (UnaryOperator<String>)resolver), resolver);
                }
                if ((paths = model.getPaths()) != null) {
                    CompositeOpenAPIModelProvider.addPathItems(paths.getPathItems(), (arg_0, arg_1) -> ((Paths)result.getPaths()).addPathItem(arg_0, arg_1), resolver);
                }
                CompositeOpenAPIModelProvider.addSecurityRequirements(model.getSecurity(), arg_0 -> ((OpenAPI)result).addSecurityRequirement(arg_0), resolver);
                CompositeOpenAPIModelProvider.addTags(model.getTags(), arg_0 -> ((OpenAPI)result).addTag(arg_0), resolver);
                CompositeOpenAPIModelProvider.addPathItems(model.getWebhooks(), CompositeOpenAPIModelProvider.resolve((arg_0, arg_1) -> ((OpenAPI)result).addWebhook(arg_0, arg_1), (UnaryOperator<String>)resolver), resolver);
            }
            return result;
        }

        private String singleton(Function<Optional<OpenAPI>, Optional<String>> function) {
            return function.apply(CompositeOpenAPIModelProvider.this.defaultModel).orElseGet(() -> ((Optional)this.models.values().stream().map(function).filter(Optional::isPresent).map(Optional::get).distinct().collect(new SingletonCollector())).orElse(null));
        }

        private <T extends Extensible<T>> Map<String, Object> extensions(Function<Optional<OpenAPI>, Optional<T>> component) {
            Stream defaultComponents = component.apply(CompositeOpenAPIModelProvider.this.defaultModel).map(Stream::of).orElse(Stream.empty());
            Stream<Extensible> deploymentComponents = this.models.values().stream().map(component).filter(Optional::isPresent).map(Optional::get);
            return Stream.concat(defaultComponents, deploymentComponents).map(Extensible::getExtensions).filter(Objects::nonNull).map(Map::entrySet).flatMap(Collection::stream).distinct().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (value1, value2) -> null, TreeMap::new));
        }

        private <T> List<T> list(Function<Optional<OpenAPI>, Optional<List<T>>> components) {
            Stream defaultComponents = components.apply(CompositeOpenAPIModelProvider.this.defaultModel).orElse(List.of()).stream();
            Stream deploymentComponents = this.models.values().stream().map(components).filter(Optional::isPresent).map(Optional::get).flatMap(Collection::stream);
            return Stream.concat(defaultComponents, deploymentComponents).distinct().toList();
        }
    }

    private static class SingletonCollector<T>
    implements Collector<T, Object, Optional<T>>,
    Function<List<T>, Optional<T>> {
        private final Collector<T, Object, Optional<T>> collector = Collectors.collectingAndThen(Collectors.toList(), this);

        SingletonCollector() {
        }

        @Override
        public Optional<T> apply(List<T> list) {
            return list.size() == 1 ? Optional.of(list.get(0)) : Optional.empty();
        }

        @Override
        public Supplier<Object> supplier() {
            return this.collector.supplier();
        }

        @Override
        public BiConsumer<Object, T> accumulator() {
            return this.collector.accumulator();
        }

        @Override
        public BinaryOperator<Object> combiner() {
            return this.collector.combiner();
        }

        @Override
        public Function<Object, Optional<T>> finisher() {
            return this.collector.finisher();
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return this.collector.characteristics();
        }
    }
}

