/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.openapi.logging;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.extension.microprofile.openapi.logging.MicroProfileOpenAPILogger;

public class MicroProfileOpenAPILogger_$logger
extends DelegatingBasicLogger
implements MicroProfileOpenAPILogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MicroProfileOpenAPILogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public MicroProfileOpenAPILogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void activatingSubsystem() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.activatingSubsystem$str(), new Object[0]);
    }

    protected String activatingSubsystem$str() {
        return "WFLYMPOAI0001: Activating MicroProfile OpenAPI Subsystem";
    }

    protected String failedToLoadStaticFile$str() {
        return "WFLYMPOAI0002: Failed to load OpenAPI '%s' from deployment '%s'";
    }

    @Override
    public final IllegalArgumentException failedToLoadStaticFile(IOException e, String fileName, String deploymentName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.failedToLoadStaticFile$str(), fileName, deploymentName), e);
        MicroProfileOpenAPILogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    @Override
    public final void endpointAlreadyRegistered(String hostName, String deployment) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.endpointAlreadyRegistered$str(), (Object)hostName, (Object)deployment);
    }

    protected String endpointAlreadyRegistered$str() {
        return "WFLYMPOAI0003: MicroProfile OpenAPI endpoint already registered for host '%s'.  Skipping OpenAPI documentation of '%s'.";
    }

    @Override
    public final void endpointRegistered(String path, String hostName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.endpointRegistered$str(), (Object)path, (Object)hostName);
    }

    protected String endpointRegistered$str() {
        return "WFLYMPOAI0004: Registered MicroProfile OpenAPI endpoint '%s' for host '%s'";
    }

    @Override
    public final void endpointUnregistered(String path, String hostName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.endpointUnregistered$str(), (Object)path, (Object)hostName);
    }

    protected String endpointUnregistered$str() {
        return "WFLYMPOAI0005: Unregistered MicroProfile OpenAPI endpoint '%s' for host '%s'";
    }

    @Override
    public final void requiredListenersNotFound(String serverName, Set<String> requisiteSchemes) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.requiredListenersNotFound$str(), (Object)serverName, requisiteSchemes);
    }

    protected String requiredListenersNotFound$str() {
        return "WFLYMPOAI0006: \u00a75.1 of MicroProfile OpenAPI specification requires that the endpoint be accessible via %2$s, but no such listeners exists for server '%1$s'.";
    }

    @Override
    public final void nonStandardEndpoint(String deploymentName, String deploymentEndpoint, String standardEndpoint) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.nonStandardEndpoint$str(), (Object)deploymentName, (Object)deploymentEndpoint, (Object)standardEndpoint);
    }

    protected String nonStandardEndpoint$str() {
        return "WFLYMPOAI0007: \u00a75.1 of MicroProfile OpenAPI specification requires documentation to be available at '%3$s', but '%1$s' is configured to use '%2$s'";
    }

    @Override
    public final void disabled(String deploymentName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.disabled$str(), (Object)deploymentName);
    }

    protected String disabled$str() {
        return "WFLYMPOAI0008: MicroProfile OpenAPI documentation disabled for '%s'";
    }

    @Override
    public final void propertyValueConflicts(String propertyName, Map<String, String> conflicts) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.propertyValueConflicts$str(), (Object)propertyName, conflicts);
    }

    protected String propertyValueConflicts$str() {
        return "WFLYMPOAI0009: Ignoring deployment-specific property value for %s due to conflicts: %s";
    }

    @Override
    public final void propertyValueOverride(String propertyName, String propertyValue) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.propertyValueOverride$str(), (Object)propertyName, (Object)propertyValue);
    }

    protected String propertyValueOverride$str() {
        return "WFLYMPOAI0010: Host configuration overrides deployment-specific property value for %s: %s";
    }
}

