/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.openapi.logging;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="WFLYMPOAI", length=4)
public interface MicroProfileOpenAPILogger
extends BasicLogger {
    public static final MicroProfileOpenAPILogger LOGGER = (MicroProfileOpenAPILogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), MicroProfileOpenAPILogger.class, (String)"org.wildfly.extension.microprofile.openapi.smallrye");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Activating MicroProfile OpenAPI Subsystem")
    public void activatingSubsystem();

    @Message(id=2, value="Failed to load OpenAPI '%s' from deployment '%s'")
    public IllegalArgumentException failedToLoadStaticFile(@Cause IOException var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3, value="MicroProfile OpenAPI endpoint already registered for host '%s'.  Skipping OpenAPI documentation of '%s'.")
    public void endpointAlreadyRegistered(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=4, value="Registered MicroProfile OpenAPI endpoint '%s' for host '%s'")
    public void endpointRegistered(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=5, value="Unregistered MicroProfile OpenAPI endpoint '%s' for host '%s'")
    public void endpointUnregistered(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=6, value="\u00a75.1 of MicroProfile OpenAPI specification requires that the endpoint be accessible via %2$s, but no such listeners exists for server '%1$s'.")
    public void requiredListenersNotFound(String var1, Set<String> var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=7, value="\u00a75.1 of MicroProfile OpenAPI specification requires documentation to be available at '%3$s', but '%1$s' is configured to use '%2$s'")
    public void nonStandardEndpoint(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=8, value="MicroProfile OpenAPI documentation disabled for '%s'")
    public void disabled(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=9, value="Ignoring deployment-specific property value for %s due to conflicts: %s")
    public void propertyValueConflicts(String var1, Map<String, String> var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10, value="Host configuration overrides deployment-specific property value for %s: %s")
    public void propertyValueOverride(String var1, String var2);
}

