/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.openapi.deployment;

import io.smallrye.openapi.api.OpenApiConfig;
import io.undertow.servlet.api.DeploymentInfo;
import java.util.AbstractMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.info.Contact;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.info.License;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.jaxrs.JaxrsAnnotations;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.msc.service.DuplicateServiceException;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.microprofile.openapi.deployment.DeploymentOpenAPIProviderServiceInstaller;
import org.wildfly.extension.microprofile.openapi.deployment.DeploymentUnitOpenAPIModelConfiguration;
import org.wildfly.extension.microprofile.openapi.logging.MicroProfileOpenAPILogger;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.deployment.UndertowDeploymentInfoService;
import org.wildfly.microprofile.openapi.OpenAPIModelConfiguration;
import org.wildfly.microprofile.openapi.OpenAPIModelProvider;
import org.wildfly.microprofile.openapi.OpenAPIModelRegistry;
import org.wildfly.microprofile.openapi.host.HostOpenAPIModelConfiguration;
import org.wildfly.microprofile.openapi.host.OpenAPIHttpHandlerServiceInstaller;
import org.wildfly.service.Dependency;
import org.wildfly.service.Installer;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.service.descriptor.TernaryServiceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class OpenAPIDocumentProcessor
implements DeploymentUnitProcessor {
    private static final Function<Optional<Info>, Optional<Contact>> INFO_CONTACT = OpenAPIDocumentProcessor.optional(Info::getContact);
    private static final Function<Optional<Info>, Optional<License>> INFO_LICENSE = OpenAPIDocumentProcessor.optional(Info::getLicense);
    private static final Function<Optional<OpenAPI>, Optional<ExternalDocumentation>> EXTERNAL_DOCUMENTATION = OpenAPIDocumentProcessor.optional(OpenAPI::getExternalDocs);
    private static final Function<Optional<OpenAPI>, Optional<Info>> INFO = OpenAPIDocumentProcessor.optional(OpenAPI::getInfo);
    private static final Function<Optional<OpenAPI>, Optional<Contact>> CONTACT = INFO.andThen(INFO_CONTACT);
    private static final Function<Optional<OpenAPI>, Optional<License>> LICENSE = INFO.andThen(INFO_LICENSE);
    private static final List<Map.Entry<String, Function<Optional<OpenAPI>, Optional<String>>>> SINGLETON_PROPERTIES = List.of(Map.entry(HostOpenAPIModelConfiguration.EXTERNAL_DOCUMENTATION_DESCRIPTION, EXTERNAL_DOCUMENTATION.andThen(OpenAPIDocumentProcessor.optional(ExternalDocumentation::getDescription))), Map.entry(HostOpenAPIModelConfiguration.EXTERNAL_DOCUMENTATION_URL, EXTERNAL_DOCUMENTATION.andThen(OpenAPIDocumentProcessor.optional(ExternalDocumentation::getUrl))), Map.entry(HostOpenAPIModelConfiguration.INFO_CONTACT_EMAIL, CONTACT.andThen(OpenAPIDocumentProcessor.optional(Contact::getEmail))), Map.entry(HostOpenAPIModelConfiguration.INFO_CONTACT_NAME, CONTACT.andThen(OpenAPIDocumentProcessor.optional(Contact::getName))), Map.entry(HostOpenAPIModelConfiguration.INFO_CONTACT_URL, CONTACT.andThen(OpenAPIDocumentProcessor.optional(Contact::getUrl))), Map.entry(HostOpenAPIModelConfiguration.INFO_DESCRIPTION, INFO.andThen(OpenAPIDocumentProcessor.optional(Info::getDescription))), Map.entry(HostOpenAPIModelConfiguration.INFO_LICENSE_IDENTIFIER, LICENSE.andThen(OpenAPIDocumentProcessor.optional(License::getIdentifier))), Map.entry(HostOpenAPIModelConfiguration.INFO_LICENSE_NAME, LICENSE.andThen(OpenAPIDocumentProcessor.optional(License::getName))), Map.entry(HostOpenAPIModelConfiguration.INFO_LICENSE_URL, LICENSE.andThen(OpenAPIDocumentProcessor.optional(License::getUrl))), Map.entry(HostOpenAPIModelConfiguration.INFO_SUMMARY, INFO.andThen(OpenAPIDocumentProcessor.optional(Info::getSummary))), Map.entry(HostOpenAPIModelConfiguration.INFO_TERMS_OF_SERVICE, INFO.andThen(OpenAPIDocumentProcessor.optional(Info::getTermsOfService))), Map.entry(HostOpenAPIModelConfiguration.INFO_TITLE, INFO.andThen(OpenAPIDocumentProcessor.optional(Info::getTitle))), Map.entry(HostOpenAPIModelConfiguration.INFO_VERSION, INFO.andThen(OpenAPIDocumentProcessor.optional(Info::getVersion))), Map.entry("jsonSchemaDialect", OpenAPIDocumentProcessor.optional(OpenAPI::getJsonSchemaDialect)), Map.entry("version", OpenAPIDocumentProcessor.optional(OpenAPI::getOpenapi)));

    private static <T, R> Function<Optional<T>, Optional<R>> optional(final Function<T, R> function) {
        return new Function<Optional<T>, Optional<R>>(){

            @Override
            public Optional<R> apply(Optional<T> value) {
                return value.map(function);
            }
        };
    }

    public void deploy(DeploymentPhaseContext context) throws DeploymentUnitProcessingException {
        block7: {
            DeploymentUnit unit = context.getDeploymentUnit();
            if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)unit)) {
                DeploymentUnitOpenAPIModelConfiguration configuration = new DeploymentUnitOpenAPIModelConfiguration(unit);
                HostOpenAPIModelConfiguration hostConfiguration = new HostOpenAPIModelConfiguration(configuration.getServerName(), configuration.getHostName());
                if (configuration.isEnabled()) {
                    OpenApiConfig config = OpenApiConfig.fromConfig((Config)configuration.getMicroProfileConfig());
                    if (config.modelReader() != null || config.filter() != null || configuration.getStaticFile().isPresent() || OpenAPIDocumentProcessor.isRestful(unit)) {
                        try {
                            new DeploymentOpenAPIProviderServiceInstaller(configuration).install(context);
                            if (!hostConfiguration.getPath().equals(configuration.getPath())) {
                                MicroProfileOpenAPILogger.LOGGER.nonStandardEndpoint(configuration.getModelName(), configuration.getPath(), hostConfiguration.getPath());
                                new OpenAPIHttpHandlerServiceInstaller((OpenAPIModelConfiguration)configuration).install(context);
                                break block7;
                            }
                            String serverName = configuration.getServerName();
                            String hostName = configuration.getHostName();
                            String modelName = configuration.getModelName();
                            final ServiceDependency deployment = ServiceDependency.on((ServiceName)UndertowService.deploymentServiceName((ServiceName)unit.getServiceName()).append(UndertowDeploymentInfoService.SERVICE_NAME));
                            ServiceDependency registration = ServiceDependency.on((BinaryServiceDescriptor)OpenAPIModelRegistry.SERVICE_DESCRIPTOR, (String)serverName, (String)hostName).combine((Dependency)ServiceDependency.on((TernaryServiceDescriptor)OpenAPIModelProvider.SERVICE_DESCRIPTOR, (String)serverName, (String)hostName, (String)modelName), (BiFunction)new BiFunction<OpenAPIModelRegistry, OpenAPIModelProvider, OpenAPIModelRegistry.Registration>(){

                                @Override
                                public OpenAPIModelRegistry.Registration apply(OpenAPIModelRegistry registry, OpenAPIModelProvider provider) {
                                    OpenAPI model = provider.getModel();
                                    String contextName = ((DeploymentInfo)deployment.get()).getContextPath().replace("/", "");
                                    Map models = registry.getModels();
                                    if (!models.isEmpty()) {
                                        Optional defaultModel = registry.getDefaultModel();
                                        Optional<OpenAPI> localModel = Optional.of(model);
                                        for (Map.Entry<String, Function<Optional<OpenAPI>, Optional<String>>> entry : SINGLETON_PROPERTIES) {
                                            Function<Optional<OpenAPI>, Optional<String>> property = entry.getValue();
                                            Optional<String> localValue = property.apply(localModel);
                                            if (!localValue.isPresent()) continue;
                                            if (property.apply(defaultModel).isEmpty()) {
                                                TreeMap<String, String> conflicts = new TreeMap<String, String>(Map.of(contextName, localValue.get()));
                                                for (Map.Entry modelEntry : models.entrySet()) {
                                                    property.apply((Optional)modelEntry.getValue()).filter(Predicate.not(localValue.get()::equals)).ifPresent(value -> conflicts.put((String)modelEntry.getKey(), (String)value));
                                                }
                                                if (conflicts.size() <= 1) continue;
                                                MicroProfileOpenAPILogger.LOGGER.propertyValueConflicts(entry.getKey(), conflicts);
                                                continue;
                                            }
                                            MicroProfileOpenAPILogger.LOGGER.propertyValueOverride(entry.getKey(), localValue.get());
                                        }
                                    }
                                    return registry.register(contextName, model);
                                }
                            });
                            ((ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((ServiceDependency)registration).requires((Consumer)deployment)).startWhen(Installer.StartWhen.INSTALLED)).onStop(OpenAPIModelRegistry.Registration::close)).build()).install(context);
                        }
                        catch (DuplicateServiceException e) {
                            MicroProfileOpenAPILogger.LOGGER.endpointAlreadyRegistered(configuration.getHostName(), configuration.getModelName());
                        }
                    }
                } else {
                    MicroProfileOpenAPILogger.LOGGER.disabled(configuration.getModelName());
                }
            }
        }
    }

    static <K, V, KR, VR> Function<Map.Entry<K, V>, Map.Entry<KR, VR>> entryMapper(final Function<K, KR> keyMapper, final Function<V, VR> valueMapper) {
        return new Function<Map.Entry<K, V>, Map.Entry<KR, VR>>(){

            @Override
            public Map.Entry<KR, VR> apply(Map.Entry<K, V> entry) {
                return new AbstractMap.SimpleImmutableEntry(keyMapper.apply(entry.getKey()), valueMapper.apply(entry.getValue()));
            }
        };
    }

    static <K, V> Predicate<Map.Entry<K, V>> entryFilter(final Predicate<K> keyFilter, final Predicate<V> valueFilter) {
        return new Predicate<Map.Entry<K, V>>(){

            @Override
            public boolean test(Map.Entry<K, V> entry) {
                return keyFilter.test(entry.getKey()) || valueFilter.test(entry.getValue());
            }
        };
    }

    private static boolean isRestful(DeploymentUnit unit) {
        CompositeIndex index = (CompositeIndex)unit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        for (JaxrsAnnotations annotation : EnumSet.allOf(JaxrsAnnotations.class)) {
            if (index.getAnnotations(annotation.getDotName()).isEmpty()) continue;
            return true;
        }
        return false;
    }
}

