/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.openapi.deployment;

import io.smallrye.openapi.runtime.io.Format;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.vfs.VirtualFile;
import org.wildfly.extension.microprofile.openapi.deployment.DeploymentOpenAPIModelConfiguration;
import org.wildfly.extension.undertow.DeploymentDefinition;

public class DeploymentUnitOpenAPIModelConfiguration
implements DeploymentOpenAPIModelConfiguration {
    private static final String RELATIVE_SERVER_URLS = "servers.relative";
    private static final Map<Format, List<String>> STATIC_FILES = new EnumMap<Format, List<String>>(Format.class);
    private final Config config;
    private final Optional<URL> staticFile;
    private final String serverName;
    private final String hostName;
    private final String modelName;
    private final Function<String, URL> resolver;

    DeploymentUnitOpenAPIModelConfiguration(DeploymentUnit unit) {
        this.config = ConfigProvider.getConfig((ClassLoader)((Module)unit.getAttachment(Attachments.MODULE)).getClassLoader());
        final VirtualFile root = ((ResourceRoot)unit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        this.resolver = new Function<String, URL>(){

            @Override
            public URL apply(String path) {
                try {
                    VirtualFile file = root.getChild(path);
                    return file.exists() ? file.toURL() : null;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
        this.staticFile = Stream.of(Format.YAML, Format.JSON).map(STATIC_FILES::get).flatMap(Collection::stream).map(this.resolver).filter(Objects::nonNull).findFirst();
        ModelNode model = ((DeploymentResourceSupport)unit.getAttachment(Attachments.DEPLOYMENT_RESOURCE_SUPPORT)).getDeploymentSubsystemModel("undertow");
        this.serverName = model.get(DeploymentDefinition.SERVER.getName()).asString();
        this.hostName = model.get(DeploymentDefinition.VIRTUAL_HOST.getName()).asString();
        this.modelName = unit.getName();
    }

    public Config getMicroProfileConfig() {
        return this.config;
    }

    @Override
    public Optional<URL> getStaticFile() {
        return this.staticFile;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getModelName() {
        return this.modelName;
    }

    @Override
    public Function<String, URL> getResourceResolver() {
        return this.resolver;
    }

    @Override
    public boolean useRelativeServerURLs() {
        return this.config.getOptionalValue("mp.openapi.extensions.servers.relative", Boolean.class).orElse(Boolean.TRUE);
    }

    static {
        STATIC_FILES.put(Format.YAML, List.of("/META-INF/openapi.yaml", "/WEB-INF/classes/META-INF/openapi.yaml", "/META-INF/openapi.yml", "/WEB-INF/classes/META-INF/openapi.yml"));
        STATIC_FILES.put(Format.JSON, List.of("/META-INF/openapi.json", "/WEB-INF/classes/META-INF/openapi.json"));
    }
}

