/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.openapi.deployment;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.SmallRyeOpenAPI;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScanner;
import io.undertow.servlet.api.DeploymentInfo;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.IndexView;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.microprofile.openapi.deployment.DeploymentOpenAPIModelConfiguration;
import org.wildfly.extension.microprofile.openapi.logging.MicroProfileOpenAPILogger;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.UndertowListener;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.deployment.UndertowDeploymentInfoService;
import org.wildfly.microprofile.openapi.OpenAPIModelProvider;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.service.Installer;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.subsystem.service.DeploymentServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class DeploymentOpenAPIProviderServiceInstaller
implements DeploymentServiceInstaller {
    private static final Set<String> REQUISITE_LISTENERS = Collections.singleton("http");
    private final DeploymentOpenAPIModelConfiguration configuration;

    public DeploymentOpenAPIProviderServiceInstaller(DeploymentOpenAPIModelConfiguration configuration) {
        this.configuration = configuration;
    }

    public void install(DeploymentPhaseContext context) {
        DeploymentUnit unit = context.getDeploymentUnit();
        final String deploymentName = unit.getName();
        ArrayList indexes = new ArrayList(((org.jboss.as.server.deployment.annotation.CompositeIndex)unit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX)).getIndexes());
        if (unit.getParent() != null) {
            indexes.addAll(((org.jboss.as.server.deployment.annotation.CompositeIndex)unit.getParent().getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX)).getIndexes());
            for (DeploymentUnit subUnit : (AttachmentList)unit.getParent().getAttachment(Attachments.ACCESSIBLE_SUB_DEPLOYMENTS)) {
                indexes.addAll(((org.jboss.as.server.deployment.annotation.CompositeIndex)subUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX)).getIndexes());
            }
        }
        final CompositeIndex index = CompositeIndex.create((Collection)indexes.stream().map(IndexView.class::cast).collect(Collectors.toList()));
        final Module module = (Module)unit.getAttachment(Attachments.MODULE);
        final JBossWebMetaData metaData = ((WarMetaData)unit.getAttachment(WarMetaData.ATTACHMENT_KEY)).getMergedJBossWebMetaData();
        final Config config = this.configuration.getMicroProfileConfig();
        final Function<String, URL> resourceResolver = this.configuration.getResourceResolver();
        final boolean useRelativeServerURLs = this.configuration.useRelativeServerURLs();
        String serverName = this.configuration.getServerName();
        String hostName = this.configuration.getHostName();
        String modelName = this.configuration.getModelName();
        final OpenApiConfig openAPIConfig = this.configuration.getOpenApiConfig();
        final ServiceDependency host = ServiceDependency.on((BinaryServiceDescriptor)Host.SERVICE_DESCRIPTOR, (String)serverName, (String)hostName);
        final ServiceDependency deployment = ServiceDependency.on((ServiceName)UndertowService.deploymentServiceName((ServiceName)unit.getServiceName()).append(UndertowDeploymentInfoService.SERVICE_NAME));
        Supplier<OpenAPIModelProvider> factory = new Supplier<OpenAPIModelProvider>(){

            @Override
            public OpenAPIModelProvider get() {
                String undertowContextPath;
                SmallRyeOpenAPI.Builder builder = SmallRyeOpenAPI.builder().enableStandardFilter(false).withApplicationClassLoader((ClassLoader)module.getClassLoader()).withConfig(config).withIndex((IndexView)index).withResourceLocator(resourceResolver).withScannerClassLoader(WildFlySecurityManager.getClassLoaderPrivileged(AnnotationScanner.class));
                OASFilter filter = OpenApiProcessor.getFilter((OpenApiConfig)openAPIConfig, (ClassLoader)module.getClassLoader(), (IndexView)index);
                if (filter != null) {
                    builder.addFilter(filter);
                }
                final String contextPath = (undertowContextPath = ((DeploymentInfo)deployment.get()).getContextPath()).endsWith("/") ? undertowContextPath.substring(0, undertowContextPath.length() - 1) : undertowContextPath;
                builder.addFilter(new OASFilter(){

                    public APIResponse filterAPIResponse(APIResponse response) {
                        response.setContent(this.filterContent(response.getContent()));
                        return this.filterReference(response);
                    }

                    public Callback filterCallback(Callback callback) {
                        return this.filterReference(callback);
                    }

                    public Header filterHeader(Header header) {
                        for (Map.Entry entry : Optional.ofNullable(header.getExamples()).orElse(Map.of()).entrySet()) {
                            header.addExample((String)entry.getKey(), this.filterExample((Example)entry.getValue()));
                        }
                        header.setContent(this.filterContent(header.getContent()));
                        return this.filterReference(header);
                    }

                    public Link filterLink(Link link) {
                        this.resolveURI(() -> ((Link)link).getOperationRef(), arg_0 -> ((Link)link).setOperationRef(arg_0));
                        return this.filterReference(link);
                    }

                    public Parameter filterParameter(Parameter parameter) {
                        for (Map.Entry entry : Optional.ofNullable(parameter.getExamples()).orElse(Map.of()).entrySet()) {
                            parameter.addExample((String)entry.getKey(), this.filterExample((Example)entry.getValue()));
                        }
                        parameter.setContent(this.filterContent(parameter.getContent()));
                        return this.filterReference(parameter);
                    }

                    public PathItem filterPathItem(PathItem pathItem) {
                        return this.filterReference(pathItem);
                    }

                    public RequestBody filterRequestBody(RequestBody requestBody) {
                        requestBody.setContent(this.filterContent(requestBody.getContent()));
                        return this.filterReference(requestBody);
                    }

                    public Schema filterSchema(Schema schema) {
                        return this.filterReference(schema);
                    }

                    public SecurityScheme filterSecurityScheme(SecurityScheme securityScheme) {
                        return this.filterReference(securityScheme);
                    }

                    public void filterOpenAPI(OpenAPI model) {
                        Components components;
                        DescriptionGroupMetaData descriptionMetaData = metaData.getDescriptionGroup();
                        String displayName = descriptionMetaData != null ? descriptionMetaData.getDisplayName() : null;
                        String title = displayName != null ? displayName : deploymentName;
                        String description = descriptionMetaData != null ? descriptionMetaData.getDescription() : null;
                        Info info = model.getInfo();
                        if (info == null) {
                            info = OASFactory.createInfo();
                            model.setInfo(info);
                        }
                        if (info.getTitle() == null) {
                            info.setTitle(title);
                        }
                        if (info.getDescription() == null) {
                            info.setDescription(description);
                        }
                        if ((components = model.getComponents()) != null) {
                            for (Map.Entry entry : Optional.of(components).map(Components::getExamples).orElse(Map.of()).entrySet()) {
                                components.addExample((String)entry.getKey(), this.filterExample((Example)entry.getValue()));
                            }
                        }
                        List listeners = ((Host)host.get()).getServer().getListeners();
                        if (listeners.stream().map(UndertowListener::getProtocol).noneMatch(REQUISITE_LISTENERS::contains)) {
                            MicroProfileOpenAPILogger.LOGGER.requiredListenersNotFound(((Host)host.get()).getServer().getName(), REQUISITE_LISTENERS);
                        }
                        if (model.getServers() == null && !useRelativeServerURLs) {
                            int aliases = ((Host)host.get()).getAllAliases().size();
                            int size = 0;
                            for (UndertowListener listener : listeners) {
                                size += aliases + listener.getSocketBinding().getClientMappings().size();
                            }
                            ArrayList<Server> servers = new ArrayList<Server>(size);
                            for (UndertowListener listener : listeners) {
                                Server server;
                                SocketBinding binding = listener.getSocketBinding();
                                TreeSet<String> virtualHosts = new TreeSet<String>(((Host)host.get()).getAllAliases());
                                virtualHosts.remove(((Host)host.get()).getName());
                                InetAddress address = binding.getAddress();
                                if (!address.isAnyLocalAddress()) {
                                    virtualHosts.add(address.getCanonicalHostName());
                                }
                                for (String virtualHost : virtualHosts) {
                                    server = DeploymentOpenAPIProviderServiceInstaller.createServer(listener.getProtocol(), virtualHost, binding.getPort());
                                    if (server == null) continue;
                                    servers.add(server);
                                }
                                for (ClientMapping mapping : binding.getClientMappings()) {
                                    server = DeploymentOpenAPIProviderServiceInstaller.createServer(listener.getProtocol(), mapping.getDestinationAddress(), mapping.getDestinationPort());
                                    if (server == null) continue;
                                    servers.add(server);
                                }
                            }
                            model.setServers(servers);
                        }
                    }

                    private Content filterContent(Content content) {
                        for (Map.Entry entry : Optional.ofNullable(content).map(Content::getMediaTypes).orElse(Map.of()).entrySet()) {
                            content.addMediaType((String)entry.getKey(), this.filterMediaType((MediaType)entry.getValue()));
                        }
                        return content;
                    }

                    private MediaType filterMediaType(MediaType type) {
                        for (Map.Entry entry : Optional.of(type).map(MediaType::getExamples).orElse(Map.of()).entrySet()) {
                            type.addExample((String)entry.getKey(), this.filterExample((Example)entry.getValue()));
                        }
                        return type;
                    }

                    private Example filterExample(Example example) {
                        this.resolveURI(() -> ((Example)example).getExternalValue(), arg_0 -> ((Example)example).setExternalValue(arg_0));
                        return this.filterReference(example);
                    }

                    private <T extends Reference<T>> T filterReference(T reference) {
                        URI uri;
                        String ref = reference.getRef();
                        if (ref != null && (uri = URI.create(ref)).getHost() == null && !uri.getPath().isEmpty()) {
                            this.resolveURI(() -> reference.getRef(), arg_0 -> reference.setRef(arg_0));
                        }
                        return reference;
                    }

                    private void resolveURI(Supplier<String> accessor, Consumer<String> mutator) {
                        String ref;
                        if (contextPath.length() > 1 && (ref = accessor.get()) != null && ref.startsWith("/")) {
                            mutator.accept(contextPath + ref);
                        }
                    }
                });
                if (contextPath.length() > 1) {
                    builder.addFilter(new OASFilter(){

                        public void filterOpenAPI(OpenAPI model) {
                            Paths paths = model.getPaths();
                            if (paths != null) {
                                Map items = Optional.ofNullable(paths.getPathItems()).orElse(Map.of());
                                for (Map.Entry entry : items.entrySet()) {
                                    String path = (String)entry.getKey();
                                    PathItem item = (PathItem)entry.getValue();
                                    paths.removePathItem(path);
                                    paths.addPathItem(contextPath + path, item);
                                }
                            }
                        }
                    });
                }
                return OpenAPIModelProvider.of((OpenAPI)builder.build().model());
            }
        };
        ((ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Supplier)factory).provides(OpenAPIModelProvider.SERVICE_DESCRIPTOR, serverName, hostName, modelName).requires(List.of(host, deployment))).startWhen(Installer.StartWhen.INSTALLED)).build()).install(context);
    }

    private static Server createServer(String protocol, String host, int port) {
        try {
            URL url = new URL(protocol, host, port, "");
            if (port == url.getDefaultPort()) {
                url = new URL(protocol, host, "");
            }
            return OASFactory.createServer().url(url.toString());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

