/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer;

import java.io.IOException;
import java.util.function.Function;
import org.jboss.as.controller.LocalModelControllerClient;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessStateNotifier;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.wildfly.extension.micrometer.MicrometerExtensionLogger;
import org.wildfly.extension.micrometer.WildFlyMicrometerConfig;
import org.wildfly.extension.micrometer.jmx.JmxMicrometerCollector;
import org.wildfly.extension.micrometer.metrics.MetricRegistration;
import org.wildfly.extension.micrometer.metrics.MicrometerCollector;
import org.wildfly.extension.micrometer.registry.WildFlyCompositeRegistry;
import org.wildfly.extension.micrometer.registry.WildFlyRegistry;

public class MicrometerService
implements AutoCloseable {
    private final WildFlyMicrometerConfig micrometerConfig;
    private final LocalModelControllerClient modelControllerClient;
    private final ProcessStateNotifier processStateNotifier;
    private final WildFlyCompositeRegistry micrometerRegistry;
    private MicrometerCollector micrometerCollector;

    private MicrometerService(WildFlyMicrometerConfig micrometerConfig, LocalModelControllerClient modelControllerClient, ProcessStateNotifier processStateNotifier, WildFlyCompositeRegistry micrometerRegistry) {
        this.micrometerConfig = micrometerConfig;
        this.modelControllerClient = modelControllerClient;
        this.processStateNotifier = processStateNotifier;
        this.micrometerRegistry = micrometerRegistry;
    }

    public void start() {
        this.micrometerCollector = new MicrometerCollector(this.modelControllerClient, this.processStateNotifier, this.micrometerRegistry, this.micrometerConfig.getSubsystemFilter());
        this.registerJmxMetrics();
    }

    public WildFlyCompositeRegistry getMicrometerRegistry() {
        return this.micrometerRegistry;
    }

    public void addRegistry(WildFlyRegistry registry) {
        this.micrometerRegistry.addRegistry(registry);
    }

    public synchronized MetricRegistration collectResourceMetrics(Resource resource, ImmutableManagementResourceRegistration mrr, Function<PathAddress, PathAddress> addressResolver) {
        return this.micrometerCollector.collectResourceMetrics(resource, mrr, addressResolver);
    }

    private void registerJmxMetrics() {
        try {
            new JmxMicrometerCollector(this.micrometerRegistry).init();
        }
        catch (IOException e) {
            throw MicrometerExtensionLogger.MICROMETER_LOGGER.failedInitializeJMXRegistrar(e);
        }
    }

    @Override
    public void close() {
        this.micrometerRegistry.close();
    }

    public static class Builder {
        private WildFlyMicrometerConfig micrometerConfig;
        private LocalModelControllerClient modelControllerClient;
        private ProcessStateNotifier processStateNotifier;
        private WildFlyCompositeRegistry micrometerRegistry;

        public Builder micrometerConfig(WildFlyMicrometerConfig micrometerConfig) {
            this.micrometerConfig = micrometerConfig;
            return this;
        }

        public Builder modelControllerClient(LocalModelControllerClient modelControllerClient) {
            this.modelControllerClient = modelControllerClient;
            return this;
        }

        public Builder processStateNotifier(ProcessStateNotifier processStateNotifier) {
            this.processStateNotifier = processStateNotifier;
            return this;
        }

        public Builder micrometerRegistry(WildFlyCompositeRegistry micrometerRegistry) {
            this.micrometerRegistry = micrometerRegistry;
            return this;
        }

        public MicrometerService build() {
            assert (this.micrometerRegistry != null && this.micrometerConfig != null && this.modelControllerClient != null && this.processStateNotifier != null);
            return new MicrometerService(this.micrometerConfig, this.modelControllerClient, this.processStateNotifier, this.micrometerRegistry);
        }
    }
}

