/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer.api;

import io.micrometer.core.instrument.MeterRegistry;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeShutdown;
import jakarta.enterprise.inject.spi.Extension;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.wildfly.security.manager.WildFlySecurityManager;

public class MicrometerCdiExtension
implements Extension {
    private static final Map<ClassLoader, MeterRegistry> REGISTRY_INSTANCES = Collections.synchronizedMap(new WeakHashMap());

    public static MeterRegistry registerApplicationRegistry(ClassLoader classLoader, MeterRegistry registry) {
        REGISTRY_INSTANCES.put(classLoader, registry);
        return registry;
    }

    public void registerMicrometerBeans(@Observes AfterBeanDiscovery abd, BeanManager beanManager) {
        abd.addBean().addTransitiveTypeClosure(MeterRegistry.class).produceWith(i -> REGISTRY_INSTANCES.get(WildFlySecurityManager.getCurrentContextClassLoaderPrivileged()));
    }

    public void beforeShutdown(@Observes BeforeShutdown bs) {
        REGISTRY_INSTANCES.remove(WildFlySecurityManager.getCurrentContextClassLoaderPrivileged());
    }
}

