/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.as.messaging.jms.JMSTopicAdd;
import org.jboss.as.messaging.jms.JMSTopicConfigurationRuntimeHandler;
import org.jboss.as.messaging.jms.JMSTopicConfigurationWriteHandler;
import org.jboss.as.messaging.jms.JMSTopicControlHandler;
import org.jboss.as.messaging.jms.JMSTopicReadAttributeHandler;
import org.jboss.as.messaging.jms.JMSTopicRemove;
import org.jboss.as.messaging.jms.JMSTopicUpdateJndiHandler;
import org.jboss.dmr.ModelType;

public class JMSTopicDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH = PathElement.pathElement((String)"jms-topic");
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.DESTINATION_ENTRIES};
    static final AttributeDefinition TOPIC_ADDRESS = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"topic-address", (ModelType)ModelType.STRING).setStorageRuntime()).build();
    static final AttributeDefinition[] READONLY_ATTRIBUTES = new AttributeDefinition[]{TOPIC_ADDRESS, CommonAttributes.TEMPORARY};
    static final AttributeDefinition DURABLE_MESSAGE_COUNT = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"durable-message-count", (ModelType)ModelType.INT).setStorageRuntime()).build();
    static final AttributeDefinition NON_DURABLE_MESSAGE_COUNT = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"non-durable-message-count", (ModelType)ModelType.INT).setStorageRuntime()).build();
    static final AttributeDefinition SUBSCRIPTION_COUNT = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"subscription-count", (ModelType)ModelType.INT).setStorageRuntime()).build();
    static final AttributeDefinition DURABLE_SUBSCRIPTION_COUNT = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"durable-subscription-count", (ModelType)ModelType.INT).setStorageRuntime()).build();
    static final AttributeDefinition NON_DURABLE_SUBSCRIPTION_COUNT = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"non-durable-subscription-count", (ModelType)ModelType.INT).setStorageRuntime()).build();
    static final AttributeDefinition[] METRICS = new AttributeDefinition[]{CommonAttributes.DELIVERING_COUNT, CommonAttributes.MESSAGES_ADDED, CommonAttributes.MESSAGE_COUNT, DURABLE_MESSAGE_COUNT, NON_DURABLE_MESSAGE_COUNT, SUBSCRIPTION_COUNT, DURABLE_SUBSCRIPTION_COUNT, NON_DURABLE_SUBSCRIPTION_COUNT};
    private final boolean registerRuntimeOnly;
    private final boolean deployed;
    private final List<AccessConstraintDefinition> accessConstraints;

    private static AttributeDefinition[] getDeploymentAttributes() {
        return new AttributeDefinition[]{((PrimitiveListAttributeDefinition.Builder)new PrimitiveListAttributeDefinition.Builder(CommonAttributes.DESTINATION_ENTRIES).setStorageRuntime()).build()};
    }

    public static JMSTopicDefinition newDeployedJMSTopicDefinition() {
        return new JMSTopicDefinition(true, true, null, null);
    }

    public JMSTopicDefinition(boolean registerRuntimeOnly) {
        this(registerRuntimeOnly, false, (OperationStepHandler)JMSTopicAdd.INSTANCE, (OperationStepHandler)JMSTopicRemove.INSTANCE);
    }

    private JMSTopicDefinition(boolean registerRuntimeOnly, boolean deployed, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        super(PATH, MessagingExtension.getResourceDescriptionResolver("jms-topic"), addHandler, removeHandler);
        this.registerRuntimeOnly = registerRuntimeOnly;
        this.deployed = deployed;
        ApplicationTypeConfig atc = new ApplicationTypeConfig("messaging", "jms-topic");
        this.accessConstraints = new ApplicationTypeAccessConstraintDefinition(atc).wrapAsList();
        this.setDeprecated(MessagingExtension.DEPRECATED_SINCE);
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        AttributeDefinition[] attributes;
        super.registerAttributes(registry);
        for (AttributeDefinition attr : attributes = this.deployed ? JMSTopicDefinition.getDeploymentAttributes() : ATTRIBUTES) {
            if (!this.registerRuntimeOnly && attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            if (this.deployed) {
                registry.registerReadOnlyAttribute(attr, (OperationStepHandler)JMSTopicConfigurationRuntimeHandler.INSTANCE);
                continue;
            }
            registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)JMSTopicConfigurationWriteHandler.INSTANCE);
        }
        if (this.registerRuntimeOnly) {
            for (AttributeDefinition attr : READONLY_ATTRIBUTES) {
                registry.registerReadOnlyAttribute(attr, (OperationStepHandler)JMSTopicReadAttributeHandler.INSTANCE);
            }
            for (AttributeDefinition metric : METRICS) {
                registry.registerMetric(metric, (OperationStepHandler)JMSTopicReadAttributeHandler.INSTANCE);
            }
        }
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        super.registerOperations(registry);
        if (this.registerRuntimeOnly && !this.deployed) {
            JMSTopicUpdateJndiHandler.registerOperations(registry, this.getResourceDescriptionResolver());
        }
        JMSTopicControlHandler.INSTANCE.registerOperations(registry, this.getResourceDescriptionResolver());
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }
}

