/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms.bridge;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import javax.transaction.TransactionManager;
import org.hornetq.jms.bridge.JMSBridge;
import org.jboss.as.messaging.logging.MessagingLogger;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.security.manager.WildFlySecurityManager;

class JMSBridgeService
implements Service<JMSBridge> {
    private final JMSBridge bridge;
    private final String bridgeName;
    private final String moduleName;
    private final InjectedValue<ExecutorService> executorInjector = new InjectedValue();

    public JMSBridgeService(String moduleName, String bridgeName, JMSBridge bridge) {
        if (bridge == null) {
            throw MessagingLogger.ROOT_LOGGER.nullVar("bridge");
        }
        this.moduleName = moduleName;
        this.bridgeName = bridgeName;
        this.bridge = bridge;
    }

    public static TransactionManager getTransactionManager(StartContext context) {
        ServiceController service = context.getController().getServiceContainer().getService(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER);
        return service == null ? null : (TransactionManager)service.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(final StartContext context) throws StartException {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    JMSBridgeService.this.bridge.setTransactionManager(JMSBridgeService.getTransactionManager(context));
                    JMSBridgeService.this.startBridge();
                    context.complete();
                }
                catch (Throwable e) {
                    context.failed(MessagingLogger.ROOT_LOGGER.failedToCreate(e, "JMS Bridge"));
                }
            }
        };
        try {
            ((ExecutorService)this.executorInjector.getValue()).execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBridge() throws Exception {
        Module module;
        if (this.moduleName != null) {
            ModuleIdentifier moduleID = ModuleIdentifier.create((String)this.moduleName);
            module = Module.getContextModuleLoader().loadModule(moduleID);
        } else {
            module = Module.forClass(JMSBridgeService.class);
        }
        ClassLoader oldTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)module.getClassLoader());
            this.bridge.start();
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
        }
        MessagingLogger.MESSAGING_LOGGER.startedService("JMS Bridge", this.bridgeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(final StopContext context) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    JMSBridgeService.this.bridge.stop();
                    MessagingLogger.MESSAGING_LOGGER.stoppedService("JMS Bridge", JMSBridgeService.this.bridgeName);
                    context.complete();
                }
                catch (Exception e) {
                    MessagingLogger.MESSAGING_LOGGER.failedToDestroy("bridge", JMSBridgeService.this.bridgeName);
                }
            }
        };
        try {
            ((ExecutorService)this.executorInjector.getValue()).execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    public JMSBridge getValue() throws IllegalStateException {
        return this.bridge;
    }

    public InjectedValue<ExecutorService> getExecutorInjector() {
        return this.executorInjector;
    }
}

