/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.messaging.BinderServiceUtil;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.messaging.jms.JMSTopicDefinition;
import org.jboss.as.messaging.jms.JMSTopicService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class JMSTopicAdd
extends AbstractAddStepHandler {
    public static final JMSTopicAdd INSTANCE = new JMSTopicAdd(JMSTopicDefinition.ATTRIBUTES);

    private JMSTopicAdd(AttributeDefinition ... attributes) {
        super(attributes);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String[] jndiBindings;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceTarget serviceTarget = context.getServiceTarget();
        JMSTopicService jmsTopicService = JMSTopicService.installService(name, hqServiceName, serviceTarget, new String[0]);
        ModelNode entries = CommonAttributes.DESTINATION_ENTRIES.resolveModelAttribute(context, model);
        for (String jndiBinding : jndiBindings = JMSServices.getJndiBindings(entries)) {
            BinderServiceUtil.installBinderService(serviceTarget, jndiBinding, jmsTopicService);
        }
    }

    @Deprecated
    public void installServices(String name, ServiceName hqServiceName, ServiceTarget serviceTarget, String[] jndiBindings) {
        JMSTopicService.installService(name, hqServiceName, serviceTarget, jndiBindings);
    }
}

