/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.HornetQReloadRequiredHandlers;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.as.messaging.logging.MessagingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class TransportParamDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH = PathElement.pathElement((String)"param");
    public static final SimpleAttributeDefinition VALUE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"value", (ModelType)ModelType.STRING).setAllowExpression(true)).setRestartAllServices()).build();

    public TransportParamDefinition(final Set<String> allowedKeys) {
        super(PATH, MessagingExtension.getResourceDescriptionResolver("transport-config.param"), (OperationStepHandler)new HornetQReloadRequiredHandlers.AddStepHandler(new AttributeDefinition[]{VALUE}){

            protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
                super.populateModel(context, operation, resource);
                context.addStep((OperationStepHandler)new CheckParameterStep(allowedKeys), OperationContext.Stage.MODEL);
            }
        }, (OperationStepHandler)new HornetQReloadRequiredHandlers.RemoveStepHandler());
        this.setDeprecated(MessagingExtension.DEPRECATED_SINCE);
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        super.registerAttributes(registry);
        registry.registerReadWriteAttribute((AttributeDefinition)VALUE, null, (OperationStepHandler)new HornetQReloadRequiredHandlers.WriteAttributeHandler(new AttributeDefinition[]{VALUE}));
    }

    private static class CheckParameterStep
    implements OperationStepHandler {
        private final Set<String> allowedKeys;

        public CheckParameterStep(Set<String> allowedKeys) {
            this.allowedKeys = allowedKeys;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String parameterName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
            if (!this.allowedKeys.isEmpty() && !this.allowedKeys.contains(parameterName)) {
                throw MessagingLogger.ROOT_LOGGER.invalidParameterName(parameterName, this.allowedKeys);
            }
            context.stepCompleted();
        }
    }
}

