/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.hornetq.api.core.management.AddressControl;
import org.hornetq.api.core.management.QueueControl;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.management.ManagementService;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.CoreAddressResource;
import org.jboss.as.messaging.logging.MessagingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class HornetQServerResource
implements Resource {
    private final Resource delegate;
    private volatile ServiceController<HornetQServer> hornetQServerServiceController;

    public HornetQServerResource() {
        this(Resource.Factory.create());
    }

    public HornetQServerResource(Resource delegate) {
        this.delegate = delegate;
    }

    public ServiceController<HornetQServer> getHornetQServerServiceController() {
        return this.hornetQServerServiceController;
    }

    public void setHornetQServerServiceController(ServiceController<HornetQServer> hornetQServerServiceController) {
        this.hornetQServerServiceController = hornetQServerServiceController;
    }

    public ModelNode getModel() {
        return this.delegate.getModel();
    }

    public void writeModel(ModelNode newModel) {
        this.delegate.writeModel(newModel);
    }

    public boolean isModelDefined() {
        return this.delegate.isModelDefined();
    }

    public boolean hasChild(PathElement element) {
        if ("core-address".equals(element.getKey())) {
            return this.hasAddressControl(element);
        }
        if ("runtime-queue".equals(element.getKey())) {
            return this.hasQueueControl(element.getValue());
        }
        return this.delegate.hasChild(element);
    }

    public Resource getChild(PathElement element) {
        if ("core-address".equals(element.getKey())) {
            return this.hasAddressControl(element) ? new CoreAddressResource(element.getValue(), this.getManagementService()) : null;
        }
        if ("runtime-queue".equals(element.getKey())) {
            return this.hasQueueControl(element.getValue()) ? PlaceholderResource.INSTANCE : null;
        }
        return this.delegate.getChild(element);
    }

    public Resource requireChild(PathElement element) {
        if ("core-address".equals(element.getKey())) {
            if (this.hasAddressControl(element)) {
                return new CoreAddressResource(element.getValue(), this.getManagementService());
            }
            throw new Resource.NoSuchResourceException(element);
        }
        if ("runtime-queue".equals(element.getKey())) {
            if (this.hasQueueControl(element.getValue())) {
                return PlaceholderResource.INSTANCE;
            }
            throw new Resource.NoSuchResourceException(element);
        }
        return this.delegate.requireChild(element);
    }

    public boolean hasChildren(String childType) {
        if ("core-address".equals(childType)) {
            return this.getChildrenNames("core-address").size() > 0;
        }
        if ("runtime-queue".equals(childType)) {
            return this.getChildrenNames("runtime-queue").size() > 0;
        }
        return this.delegate.hasChildren(childType);
    }

    public Resource navigate(PathAddress address) {
        if (address.size() > 0 && "core-address".equals(address.getElement(0).getKey())) {
            if (address.size() > 1) {
                throw new Resource.NoSuchResourceException(address.getElement(1));
            }
            return new CoreAddressResource(address.getElement(0).getValue(), this.getManagementService());
        }
        if (address.size() > 0 && "runtime-queue".equals(address.getElement(0).getKey())) {
            if (address.size() > 1) {
                throw new Resource.NoSuchResourceException(address.getElement(1));
            }
            return PlaceholderResource.INSTANCE;
        }
        return this.delegate.navigate(address);
    }

    public Set<String> getChildTypes() {
        HashSet<String> result = new HashSet<String>(this.delegate.getChildTypes());
        result.add("core-address");
        result.add("runtime-queue");
        return result;
    }

    public Set<String> getChildrenNames(String childType) {
        if ("core-address".equals(childType)) {
            return this.getCoreAddressNames();
        }
        if ("runtime-queue".equals(childType)) {
            return this.getCoreQueueNames();
        }
        return this.delegate.getChildrenNames(childType);
    }

    public Set<Resource.ResourceEntry> getChildren(String childType) {
        if ("core-address".equals(childType)) {
            HashSet<Resource.ResourceEntry> result = new HashSet<Resource.ResourceEntry>();
            for (String name : this.getCoreAddressNames()) {
                result.add(new CoreAddressResource.CoreAddressResourceEntry(name, this.getManagementService()));
            }
            return result;
        }
        if ("runtime-queue".equals(childType)) {
            LinkedHashSet<Resource.ResourceEntry> result = new LinkedHashSet<Resource.ResourceEntry>();
            for (String name : this.getCoreQueueNames()) {
                result.add((Resource.ResourceEntry)new PlaceholderResource.PlaceholderResourceEntry("runtime-queue", name));
            }
            return result;
        }
        return this.delegate.getChildren(childType);
    }

    public void registerChild(PathElement address, Resource resource) {
        String type = address.getKey();
        if ("core-address".equals(type) || "runtime-queue".equals(type)) {
            throw MessagingLogger.ROOT_LOGGER.canNotRegisterResourceOfType(type);
        }
        this.delegate.registerChild(address, resource);
    }

    public Resource removeChild(PathElement address) {
        String type = address.getKey();
        if ("core-address".equals(type) || "runtime-queue".equals(type)) {
            throw MessagingLogger.ROOT_LOGGER.canNotRemoveResourceOfType(type);
        }
        return this.delegate.removeChild(address);
    }

    public boolean isRuntime() {
        return this.delegate.isRuntime();
    }

    public boolean isProxy() {
        return this.delegate.isProxy();
    }

    public Resource clone() {
        HornetQServerResource clone = new HornetQServerResource(this.delegate.clone());
        clone.setHornetQServerServiceController(this.hornetQServerServiceController);
        return clone;
    }

    private boolean hasAddressControl(PathElement element) {
        ManagementService managementService = this.getManagementService();
        return managementService == null ? false : managementService.getResource("core.address." + element.getValue()) != null;
    }

    private boolean hasQueueControl(String name) {
        ManagementService managementService = this.getManagementService();
        return managementService == null ? false : managementService.getResource("core.queue." + name) != null;
    }

    private Set<String> getCoreAddressNames() {
        ManagementService managementService = this.getManagementService();
        if (managementService == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (Object obj : managementService.getResources(AddressControl.class)) {
            AddressControl ac = (AddressControl)AddressControl.class.cast(obj);
            result.add(ac.getAddress());
        }
        return result;
    }

    private Set<String> getCoreQueueNames() {
        ManagementService managementService = this.getManagementService();
        if (managementService == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (Object obj : managementService.getResources(QueueControl.class)) {
            QueueControl qc = (QueueControl)QueueControl.class.cast(obj);
            result.add(qc.getName());
        }
        return result;
    }

    private ManagementService getManagementService() {
        if (this.hornetQServerServiceController == null || this.hornetQServerServiceController.getState() != ServiceController.State.UP) {
            return null;
        }
        return ((HornetQServer)this.hornetQServerServiceController.getValue()).getManagementService();
    }
}

