/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public enum Namespace {
    UNKNOWN(null),
    MESSAGING_1_0("urn:jboss:domain:messaging:1.0"),
    MESSAGING_1_1("urn:jboss:domain:messaging:1.1"),
    MESSAGING_1_2("urn:jboss:domain:messaging:1.2"),
    MESSAGING_1_3("urn:jboss:domain:messaging:1.3"),
    MESSAGING_1_4("urn:jboss:domain:messaging:1.4"),
    MESSAGING_2_0("urn:jboss:domain:messaging:2.0");

    public static final Namespace CURRENT;
    private final String name;
    private static final Map<String, Namespace> MAP;

    private Namespace(String name) {
        this.name = name;
    }

    public String getUriString() {
        return this.name;
    }

    public QName getQName() {
        return new QName(this.name, "subsystem");
    }

    public static Namespace forUri(String uri) {
        Namespace element = MAP.get(uri);
        return element == null ? UNKNOWN : element;
    }

    static {
        CURRENT = MESSAGING_2_0;
        HashMap<String, Namespace> map = new HashMap<String, Namespace>();
        for (Namespace namespace : Namespace.values()) {
            String name = namespace.getUriString();
            if (name == null) continue;
            map.put(name, namespace);
        }
        MAP = map;
    }
}

