/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import javax.naming.InitialContext;
import org.jboss.as.messaging.MessagingLogger;
import org.jboss.as.naming.ContextListAndJndiViewManagedReferenceFactory;
import org.jboss.as.naming.ContextListManagedReferenceFactory;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.jboss.msc.value.Values;

public class BinderServiceUtil {
    public static void installBinderService(ServiceTarget serviceTarget, String name, Object obj) {
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)name);
        BinderService binderService = new BinderService(bindInfo.getBindName());
        serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector()).addInjection((Injector)binderService.getManagedObjectInjector(), (Object)new ValueManagedReferenceFactory(Values.immediateValue((Object)obj))).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    public static void installAliasBinderService(ServiceTarget serviceTarget, ContextNames.BindInfo bindInfo, final String alias) {
        ContextNames.BindInfo aliasBindInfo = ContextNames.bindInfoFor((String)alias);
        BinderService aliasBinderService = new BinderService(alias);
        aliasBinderService.getManagedObjectInjector().inject((Object)new AliasManagedReferenceFactory(bindInfo.getAbsoluteJndiName()));
        serviceTarget.addService(aliasBindInfo.getBinderServiceName(), (Service)aliasBinderService).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)aliasBinderService.getNamingStoreInjector()).addDependency(bindInfo.getBinderServiceName()).addListener((ServiceListener)new AbstractServiceListener<ManagedReferenceFactory>(){

            public void transition(ServiceController<? extends ManagedReferenceFactory> controller, ServiceController.Transition transition) {
                switch (transition) {
                    case STARTING_to_UP: {
                        MessagingLogger.ROOT_LOGGER.boundJndiName(alias);
                        break;
                    }
                    case STOPPING_to_DOWN: {
                        MessagingLogger.ROOT_LOGGER.unboundJndiName(alias);
                        break;
                    }
                    case REMOVING_to_REMOVED: {
                        MessagingLogger.ROOT_LOGGER.debugf("Removed messaging object [%s]", alias);
                    }
                }
            }
        }).install();
    }

    private static final class AliasManagedReferenceFactory
    implements ContextListAndJndiViewManagedReferenceFactory {
        private final String name;

        public AliasManagedReferenceFactory(String name) {
            this.name = name;
        }

        public ManagedReference getReference() {
            try {
                Object value = new InitialContext().lookup(this.name);
                return new ValueManagedReference((Value)new ImmediateValue(value));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String getInstanceClassName() {
            Object value = this.getReference().getInstance();
            return value != null ? value.getClass().getName() : ContextListManagedReferenceFactory.DEFAULT_INSTANCE_CLASS_NAME;
        }

        public String getJndiViewInstanceValue() {
            return String.valueOf(this.getReference().getInstance());
        }
    }
}

